<?php

namespace App\Http\Controllers;

use App\Models\TransactionDetail;
use App\Models\Transaction;
use Illuminate\Http\Request;

class TransactionDetailController extends Controller
{
    public function index(Request $request, $transactionId)
    {
        $transaction = Transaction::findOrFail($transactionId);

        $details = TransactionDetail::where('transaction_id', $transactionId)
            ->with('product')
            ->get();

        return response()->json([
            'success' => true,
            'data' => [
                'transaction' => $transaction,
                'details' => $details,
            ],
        ]);
    }

    public function show(TransactionDetail $transactionDetail)
    {
        $transactionDetail->load(['transaction', 'product']);

        return response()->json([
            'success' => true,
            'data' => $transactionDetail,
        ]);
    }

    public function getByTransaction($transactionId)
    {
        $details = TransactionDetail::where('transaction_id', $transactionId)
            ->with('product')
            ->get();

        $summary = [
            'total_items' => $details->count(),
            'total_quantity' => $details->sum('quantity'),
            'total_amount' => $details->sum('subtotal'),
        ];

        return response()->json([
            'success' => true,
            'data' => [
                'details' => $details,
                'summary' => $summary,
            ],
        ]);
    }
}
