<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Obat Bebas',
                'description' => 'Obat yang dapat dibeli tanpa resep dokter',
                'is_active' => true,
            ],
            [
                'name' => 'Obat Keras',
                'description' => 'Obat yang memerlukan resep dokter',
                'is_active' => true,
            ],
            [
                'name' => 'Vitamin & Suplemen',
                'description' => 'Produk kesehatan dan suplemen',
                'is_active' => true,
            ],
            [
                'name' => 'Obat Herbal',
                'description' => 'Obat-obatan tradisional dan herbal',
                'is_active' => true,
            ],
            [
                'name' => 'Alat Kesehatan',
                'description' => 'Peralatan medis dan kesehatan',
                'is_active' => true,
            ],
            [
                'name' => 'Perawatan Bayi',
                'description' => 'Produk perawatan untuk bayi',
                'is_active' => true,
            ],
            [
                'name' => 'Skincare',
                'description' => 'Produk perawatan kulit',
                'is_active' => true,
            ],
            [
                'name' => 'Sanitasi',
                'description' => 'Produk kebersihan dan sanitasi',
                'is_active' => true,
            ],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
