<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $products = [
            // Obat Bebas
            [
                'code' => 'OB001',
                'name' => 'Paracetamol 500mg',
                'category_id' => 1,
                'supplier_id' => 1,
                'description' => 'Obat penurun panas dan pereda nyeri',
                'purchase_price' => 5000,
                'selling_price' => 8000,
                'stock' => 150,
                'minimum_stock' => 50,
                'unit' => 'strip',
                'expired_date' => '2026-12-31',
                'is_active' => true,
            ],
            [
                'code' => 'OB002',
                'name' => 'Bodrex Tablet',
                'category_id' => 1,
                'supplier_id' => 4,
                'description' => 'Obat sakit kepala',
                'purchase_price' => 3000,
                'selling_price' => 5000,
                'stock' => 200,
                'minimum_stock' => 60,
                'unit' => 'strip',
                'expired_date' => '2026-10-15',
                'is_active' => true,
            ],
            [
                'code' => 'OB003',
                'name' => 'Antangin Syrup',
                'category_id' => 1,
                'supplier_id' => 7,
                'description' => 'Obat masuk angin',
                'purchase_price' => 2500,
                'selling_price' => 4000,
                'stock' => 100,
                'minimum_stock' => 40,
                'unit' => 'botol',
                'expired_date' => '2026-08-20',
                'is_active' => true,
            ],

            // Obat Keras
            [
                'code' => 'OK001',
                'name' => 'Amoxicillin 500mg',
                'category_id' => 2,
                'supplier_id' => 2,
                'description' => 'Antibiotik untuk infeksi bakteri',
                'purchase_price' => 15000,
                'selling_price' => 22000,
                'stock' => 80,
                'minimum_stock' => 30,
                'unit' => 'strip',
                'expired_date' => '2027-01-15',
                'is_active' => true,
            ],
            [
                'code' => 'OK002',
                'name' => 'Ciprofloxacin 500mg',
                'category_id' => 2,
                'supplier_id' => 3,
                'description' => 'Antibiotik untuk berbagai infeksi',
                'purchase_price' => 20000,
                'selling_price' => 30000,
                'stock' => 60,
                'minimum_stock' => 25,
                'unit' => 'strip',
                'expired_date' => '2026-11-30',
                'is_active' => true,
            ],

            // Vitamin & Suplemen
            [
                'code' => 'VS001',
                'name' => 'Vitamin C 500mg',
                'category_id' => 3,
                'supplier_id' => 2,
                'description' => 'Suplemen vitamin C untuk daya tahan tubuh',
                'purchase_price' => 12000,
                'selling_price' => 18000,
                'stock' => 120,
                'minimum_stock' => 40,
                'unit' => 'botol',
                'expired_date' => '2027-03-25',
                'is_active' => true,
            ],
            [
                'code' => 'VS002',
                'name' => 'Vitamin B Complex',
                'category_id' => 3,
                'supplier_id' => 2,
                'description' => 'Suplemen vitamin B kompleks',
                'purchase_price' => 15000,
                'selling_price' => 23000,
                'stock' => 90,
                'minimum_stock' => 35,
                'unit' => 'botol',
                'expired_date' => '2027-02-10',
                'is_active' => true,
            ],
            [
                'code' => 'VS003',
                'name' => 'Omega 3 Fish Oil',
                'category_id' => 3,
                'supplier_id' => 5,
                'description' => 'Suplemen minyak ikan omega 3',
                'purchase_price' => 35000,
                'selling_price' => 50000,
                'stock' => 70,
                'minimum_stock' => 20,
                'unit' => 'botol',
                'expired_date' => '2027-05-15',
                'is_active' => true,
            ],

            // Obat Herbal
            [
                'code' => 'OH001',
                'name' => 'Tolak Angin Cair',
                'category_id' => 4,
                'supplier_id' => 6,
                'description' => 'Obat herbal masuk angin',
                'purchase_price' => 2000,
                'selling_price' => 3500,
                'stock' => 250,
                'minimum_stock' => 80,
                'unit' => 'sachet',
                'expired_date' => '2026-09-30',
                'is_active' => true,
            ],
            [
                'code' => 'OH002',
                'name' => 'Habbatussauda Oil',
                'category_id' => 4,
                'supplier_id' => 6,
                'description' => 'Minyak habbatussauda untuk kesehatan',
                'purchase_price' => 25000,
                'selling_price' => 38000,
                'stock' => 50,
                'minimum_stock' => 20,
                'unit' => 'botol',
                'expired_date' => '2027-01-20',
                'is_active' => true,
            ],

            // Alat Kesehatan
            [
                'code' => 'AK001',
                'name' => 'Masker Medis 3 Ply',
                'category_id' => 5,
                'supplier_id' => 1,
                'description' => 'Masker kesehatan 3 lapis',
                'purchase_price' => 25000,
                'selling_price' => 35000,
                'stock' => 300,
                'minimum_stock' => 100,
                'unit' => 'box',
                'expired_date' => null,
                'is_active' => true,
            ],
            [
                'code' => 'AK002',
                'name' => 'Thermometer Digital',
                'category_id' => 5,
                'supplier_id' => 4,
                'description' => 'Termometer digital untuk mengukur suhu tubuh',
                'purchase_price' => 35000,
                'selling_price' => 55000,
                'stock' => 45,
                'minimum_stock' => 15,
                'unit' => 'pcs',
                'expired_date' => null,
                'is_active' => true,
            ],
            [
                'code' => 'AK003',
                'name' => 'Tensimeter Digital',
                'category_id' => 5,
                'supplier_id' => 4,
                'description' => 'Alat pengukur tekanan darah digital',
                'purchase_price' => 200000,
                'selling_price' => 300000,
                'stock' => 20,
                'minimum_stock' => 5,
                'unit' => 'pcs',
                'expired_date' => null,
                'is_active' => true,
            ],

            // Perawatan Bayi
            [
                'code' => 'PB001',
                'name' => 'Baby Oil 200ml',
                'category_id' => 6,
                'supplier_id' => 5,
                'description' => 'Minyak bayi untuk perawatan kulit',
                'purchase_price' => 15000,
                'selling_price' => 25000,
                'stock' => 85,
                'minimum_stock' => 30,
                'unit' => 'botol',
                'expired_date' => '2027-04-15',
                'is_active' => true,
            ],
            [
                'code' => 'PB002',
                'name' => 'Baby Powder 100gr',
                'category_id' => 6,
                'supplier_id' => 5,
                'description' => 'Bedak bayi',
                'purchase_price' => 12000,
                'selling_price' => 20000,
                'stock' => 95,
                'minimum_stock' => 35,
                'unit' => 'botol',
                'expired_date' => '2027-06-20',
                'is_active' => true,
            ],

            // Skincare
            [
                'code' => 'SK001',
                'name' => 'Sunscreen SPF 50',
                'category_id' => 7,
                'supplier_id' => 7,
                'description' => 'Tabir surya SPF 50',
                'purchase_price' => 45000,
                'selling_price' => 70000,
                'stock' => 65,
                'minimum_stock' => 25,
                'unit' => 'tube',
                'expired_date' => '2027-08-10',
                'is_active' => true,
            ],
            [
                'code' => 'SK002',
                'name' => 'Facial Wash Anti Acne',
                'category_id' => 7,
                'supplier_id' => 7,
                'description' => 'Sabun cuci muka anti jerawat',
                'purchase_price' => 20000,
                'selling_price' => 35000,
                'stock' => 110,
                'minimum_stock' => 40,
                'unit' => 'tube',
                'expired_date' => '2027-07-05',
                'is_active' => true,
            ],

            // Sanitasi
            [
                'code' => 'SN001',
                'name' => 'Hand Sanitizer 100ml',
                'category_id' => 8,
                'supplier_id' => 1,
                'description' => 'Pembersih tangan antiseptik',
                'purchase_price' => 8000,
                'selling_price' => 15000,
                'stock' => 180,
                'minimum_stock' => 60,
                'unit' => 'botol',
                'expired_date' => '2027-12-31',
                'is_active' => true,
            ],
            [
                'code' => 'SN002',
                'name' => 'Dettol Antiseptic 500ml',
                'category_id' => 8,
                'supplier_id' => 1,
                'description' => 'Cairan antiseptik',
                'purchase_price' => 25000,
                'selling_price' => 40000,
                'stock' => 75,
                'minimum_stock' => 30,
                'unit' => 'botol',
                'expired_date' => '2027-10-20',
                'is_active' => true,
            ],

            // Low Stock Items (for testing)
            [
                'code' => 'LS001',
                'name' => 'Obat Batuk Hitam',
                'category_id' => 1,
                'supplier_id' => 3,
                'description' => 'Obat batuk tradisional',
                'purchase_price' => 8000,
                'selling_price' => 12000,
                'stock' => 8,
                'minimum_stock' => 20,
                'unit' => 'botol',
                'expired_date' => '2026-05-15',
                'is_active' => true,
            ],
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}
