<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Supplier;

class SupplierSeeder extends Seeder
{
    public function run(): void
    {
        $suppliers = [
            [
                'name' => 'PT Kimia Farma',
                'company_name' => 'Kimia Farma Tbk',
                'phone' => '021-4250451',
                'email' => 'info@kimiafarma.co.id',
                'address' => 'Jl. Veteran No. 9, Jakarta Pusat',
                'is_active' => true,
            ],
            [
                'name' => 'PT Kalbe Farma',
                'company_name' => 'Kalbe Farma Tbk',
                'phone' => '021-4605555',
                'email' => 'corporate@kalbe.co.id',
                'address' => 'Gedung Kalbe, Jl. Let. Jend. Suprapto, Jakarta',
                'is_active' => true,
            ],
            [
                'name' => 'PT Indofarma',
                'company_name' => 'Indofarma Tbk',
                'phone' => '021-8191808',
                'email' => 'info@indofarma.id',
                'address' => 'Jl. Indofarma No. 1, Bekasi',
                'is_active' => true,
            ],
            [
                'name' => 'PT Tempo Scan Pacific',
                'company_name' => 'Tempo Scan Pacific Tbk',
                'phone' => '021-4682608',
                'email' => 'info@temposcanpacific.com',
                'address' => 'Tempo Building, Jakarta',
                'is_active' => true,
            ],
            [
                'name' => 'PT Combiphar',
                'company_name' => 'Combiphar',
                'phone' => '0341-396500',
                'email' => 'info@combiphar.com',
                'address' => 'Jl. Raya Kedung Kandang, Malang',
                'is_active' => true,
            ],
            [
                'name' => 'PT Sanbe Farma',
                'company_name' => 'Sanbe Farma',
                'phone' => '022-5400071',
                'email' => 'info@sanbe.co.id',
                'address' => 'Jl. Tamansari No. 80, Bandung',
                'is_active' => true,
            ],
            [
                'name' => 'PT Dexa Medica',
                'company_name' => 'Dexa Medica',
                'phone' => '021-2963000',
                'email' => 'info@dexa-medica.com',
                'address' => 'Jl. Bambang Utoyo No. 138, Tangerang',
                'is_active' => true,
            ],
        ];

        foreach ($suppliers as $supplier) {
            Supplier::create($supplier);
        }
    }
}
