<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Transaction;
use App\Models\TransactionDetail;
use App\Models\Product;
use Carbon\Carbon;

class TransactionSeeder extends Seeder
{
    public function run(): void
    {
        // Transaction 1 - Today
        $transaction1 = Transaction::create([
            'invoice_number' => Transaction::generateInvoiceNumber(),
            'user_id' => 2, // Budi
            'customer_name' => 'Ibu Sari',
            'subtotal' => 46000,
            'discount' => 0,
            'tax' => 0,
            'total' => 46000,
            'paid' => 50000,
            'change' => 4000,
            'payment_method' => 'cash',
            'notes' => 'Pelanggan langganan',
            'created_at' => now(),
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction1->id,
            'product_id' => 1,
            'product_name' => 'Paracetamol 500mg',
            'price' => 8000,
            'quantity' => 2,
            'subtotal' => 16000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction1->id,
            'product_id' => 6,
            'product_name' => 'Vitamin C 500mg',
            'price' => 18000,
            'quantity' => 1,
            'subtotal' => 18000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction1->id,
            'product_id' => 15,
            'product_name' => 'Baby Oil 200ml',
            'price' => 25000,
            'quantity' => 1,
            'subtotal' => 25000,
        ]);

        // Update stock
        Product::find(1)->decrement('stock', 2);
        Product::find(6)->decrement('stock', 1);
        Product::find(15)->decrement('stock', 1);

        // Transaction 2 - Today
        $transaction2 = Transaction::create([
            'invoice_number' => Transaction::generateInvoiceNumber(),
            'user_id' => 3, // Siti
            'customer_name' => 'Pak Ahmad',
            'subtotal' => 95000,
            'discount' => 5000,
            'tax' => 0,
            'total' => 90000,
            'paid' => 100000,
            'change' => 10000,
            'payment_method' => 'cash',
            'notes' => null,
            'created_at' => now()->subHours(2),
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction2->id,
            'product_id' => 11,
            'product_name' => 'Masker Medis 3 Ply',
            'price' => 35000,
            'quantity' => 2,
            'subtotal' => 70000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction2->id,
            'product_id' => 19,
            'product_name' => 'Hand Sanitizer 100ml',
            'price' => 15000,
            'quantity' => 1,
            'subtotal' => 15000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction2->id,
            'product_id' => 2,
            'product_name' => 'Bodrex Tablet',
            'price' => 5000,
            'quantity' => 2,
            'subtotal' => 10000,
        ]);

        Product::find(11)->decrement('stock', 2);
        Product::find(19)->decrement('stock', 1);
        Product::find(2)->decrement('stock', 2);

        // Transaction 3 - Yesterday
        $transaction3 = Transaction::create([
            'invoice_number' => 'INV-' . now()->subDay()->format('Ymd') . '-0001',
            'user_id' => 2,
            'customer_name' => 'Ibu Ratna',
            'subtotal' => 300000,
            'discount' => 0,
            'tax' => 0,
            'total' => 300000,
            'paid' => 300000,
            'change' => 0,
            'payment_method' => 'debit',
            'notes' => 'Pembayaran kartu debit BCA',
            'created_at' => now()->subDay(),
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction3->id,
            'product_id' => 13,
            'product_name' => 'Tensimeter Digital',
            'price' => 300000,
            'quantity' => 1,
            'subtotal' => 300000,
        ]);

        Product::find(13)->decrement('stock', 1);

        // Transaction 4 - This week
        $transaction4 = Transaction::create([
            'invoice_number' => 'INV-' . now()->subDays(3)->format('Ymd') . '-0001',
            'user_id' => 4, // Andi
            'customer_name' => null,
            'subtotal' => 78000,
            'discount' => 3000,
            'tax' => 0,
            'total' => 75000,
            'paid' => 75000,
            'change' => 0,
            'payment_method' => 'qris',
            'notes' => 'Bayar via QRIS',
            'created_at' => now()->subDays(3),
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction4->id,
            'product_id' => 4,
            'product_name' => 'Amoxicillin 500mg',
            'price' => 22000,
            'quantity' => 1,
            'subtotal' => 22000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction4->id,
            'product_id' => 7,
            'product_name' => 'Vitamin B Complex',
            'price' => 23000,
            'quantity' => 1,
            'subtotal' => 23000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction4->id,
            'product_id' => 17,
            'product_name' => 'Sunscreen SPF 50',
            'price' => 70000,
            'quantity' => 1,
            'subtotal' => 70000,
        ]);

        Product::find(4)->decrement('stock', 1);
        Product::find(7)->decrement('stock', 1);
        Product::find(17)->decrement('stock', 1);

        // Transaction 5 - This week
        $transaction5 = Transaction::create([
            'invoice_number' => 'INV-' . now()->subDays(5)->format('Ymd') . '-0001',
            'user_id' => 3,
            'customer_name' => 'Pak Budi',
            'subtotal' => 148000,
            'discount' => 8000,
            'tax' => 0,
            'total' => 140000,
            'paid' => 150000,
            'change' => 10000,
            'payment_method' => 'cash',
            'notes' => null,
            'created_at' => now()->subDays(5),
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction5->id,
            'product_id' => 8,
            'product_name' => 'Omega 3 Fish Oil',
            'price' => 50000,
            'quantity' => 2,
            'subtotal' => 100000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction5->id,
            'product_id' => 10,
            'product_name' => 'Habbatussauda Oil',
            'price' => 38000,
            'quantity' => 1,
            'subtotal' => 38000,
        ]);

        TransactionDetail::create([
            'transaction_id' => $transaction5->id,
            'product_id' => 3,
            'product_name' => 'Antangin Syrup',
            'price' => 4000,
            'quantity' => 1,
            'subtotal' => 4000,
        ]);

        Product::find(8)->decrement('stock', 2);
        Product::find(10)->decrement('stock', 1);
        Product::find(3)->decrement('stock', 1);
    }
}
