<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // Admin User
        User::create([
            'name' => 'Admin ApoteQu',
            'email' => 'admin@apotequ.com',
            'password' => Hash::make('password123'),
            'role' => 'admin',
            'phone' => '081234567890',
            'is_active' => true,
        ]);

        // Cashier Users
        User::create([
            'name' => 'Budi Santoso',
            'email' => 'budi@apotequ.com',
            'password' => Hash::make('password123'),
            'role' => 'cashier',
            'phone' => '081234567891',
            'is_active' => true,
        ]);

        User::create([
            'name' => 'Siti Nurhaliza',
            'email' => 'siti@apotequ.com',
            'password' => Hash::make('password123'),
            'role' => 'cashier',
            'phone' => '081234567892',
            'is_active' => true,
        ]);

        User::create([
            'name' => 'Andi Wijaya',
            'email' => 'andi@apotequ.com',
            'password' => Hash::make('password123'),
            'role' => 'cashier',
            'phone' => '081234567893',
            'is_active' => true,
        ]);

        User::create([
            'name' => 'Dewi Lestari',
            'email' => 'dewi@apotequ.com',
            'password' => Hash::make('password123'),
            'role' => 'cashier',
            'phone' => '081234567894',
            'is_active' => false, // Inactive user
        ]);
    }
}
