<?php

namespace App\Console\Commands;

use App\Jobs\SendAttendanceReminderJob;
use Illuminate\Console\Command;

class SendAttendanceReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'attendance:send-reminder {type=check_in}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send attendance reminder to guru via WhatsApp';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $type = $this->argument('type');

        if (!in_array($type, ['check_in', 'check_out'])) {
            $this->error('Invalid reminder type. Use: check_in or check_out');
            return 1;
        }

        $this->info("Sending {$type} reminders...");

        SendAttendanceReminderJob::dispatch($type);

        $this->info("Reminder job dispatched successfully!");

        return 0;
    }
}
