<?php

namespace App\Exports;

use App\Models\GuruMengajar;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class GuruMengajarExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $tahunAjaran;
    protected $kelasId;

    public function __construct($tahunAjaran = null, $kelasId = null)
    {
        $this->tahunAjaran = $tahunAjaran;
        $this->kelasId = $kelasId;
    }

    public function collection()
    {
        return GuruMengajar::with(['guru.user', 'mataPelajaran', 'kelas'])
            ->when($this->tahunAjaran, function ($q) {
                $q->where('tahun_ajaran', $this->tahunAjaran);
            })
            ->when($this->kelasId, function ($q) {
                $q->where('kelas_id', $this->kelasId);
            })
            ->get();
    }

    public function headings(): array
    {
        return [
            'No',
            'NIP Guru',
            'Nama Guru',
            'Kode Mapel',
            'Nama Mata Pelajaran',
            'JTM',
            'Kelas',
            'Tahun Ajaran',
        ];
    }

    public function map($guruMengajar): array
    {
        static $no = 0;
        $no++;

        return [
            $no,
            $guruMengajar->guru->nip ?? '-',
            $guruMengajar->guru->user->name ?? '-',
            $guruMengajar->mataPelajaran->kode_mapel ?? '-',
            $guruMengajar->mataPelajaran->nama_mapel ?? '-',
            $guruMengajar->mataPelajaran->jtm ?? '-',
            $guruMengajar->kelas->nama_kelas ?? '-',
            $guruMengajar->tahun_ajaran,
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
