<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class GuruMengajarTemplateExport implements FromArray, WithHeadings, WithStyles
{
    public function array(): array
    {
        // Return sample data
        return [
            ['197001011990031001', 'IPA', '7A'],
            ['197001011990031002', 'MAT', '7B'],
            ['197001011990031003', 'BIND', '8A'],
        ];
    }

    public function headings(): array
    {
        return [
            'nip_guru',
            'kode_mapel',
            'nama_kelas',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
