<?php

namespace App\Exports;

use App\Models\MataPelajaran;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class MataPelajaranExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $tahunAjaran;
    protected $tingkat;

    public function __construct($tahunAjaran = null, $tingkat = null)
    {
        $this->tahunAjaran = $tahunAjaran;
        $this->tingkat = $tingkat;
    }

    public function collection()
    {
        return MataPelajaran::query()
            ->when($this->tahunAjaran, function ($q) {
                $q->where('tahun_ajaran', $this->tahunAjaran);
            })
            ->when($this->tingkat, function ($q) {
                $q->where('tingkat', $this->tingkat);
            })
            ->orderBy('tingkat')
            ->orderBy('nama_mapel')
            ->get();
    }

    public function headings(): array
    {
        return [
            'No',
            'Kode Mapel',
            'Nama Mata Pelajaran',
            'JTM',
            'KKM',
            'Tingkat',
            'Kelompok',
            'Tahun Ajaran',
            'Status',
        ];
    }

    public function map($mapel): array
    {
        static $no = 0;
        $no++;

        return [
            $no,
            $mapel->kode_mapel,
            $mapel->nama_mapel,
            $mapel->jtm,
            $mapel->kkm,
            $mapel->tingkat,
            $mapel->kelompok,
            $mapel->tahun_ajaran,
            $mapel->is_active ? 'Aktif' : 'Nonaktif',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
