<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class MataPelajaranTemplateExport implements FromArray, WithHeadings, WithStyles
{
    public function array(): array
    {
        // Return empty array or sample data
        return [
            ['IPA', 'Ilmu Pengetahuan Alam', 5, 75, 'MTs', 'wajib'],
            ['MAT', 'Matematika', 6, 75, 'MTs', 'wajib'],
            ['BIND', 'Bahasa Indonesia', 5, 75, 'MTs', 'wajib'],
        ];
    }

    public function headings(): array
    {
        return [
            'kode_mapel',
            'nama_mapel',
            'jtm',
            'kkm',
            'tingkat',
            'kelompok',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
