<?php

namespace App\Exports;

use App\Models\News;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class NewsExport implements FromCollection, WithHeadings, WithMapping, WithStyles, WithColumnWidths
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return News::with('user:id,name')
            ->latest()
            ->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Judul',
            'Slug',
            'Kategori',
            'Status',
            'Penulis',
            'Views',
            'Featured',
            'Headline',
            'Tanggal Publish',
            'Dibuat Tanggal',
        ];
    }

    /**
     * @param News $news
     */
    public function map($news): array
    {
        return [
            $news->id,
            $news->title,
            $news->slug,
            ucfirst($news->category),
            ucfirst($news->status),
            $news->user->name ?? 'N/A',
            $news->views_count,
            $news->is_featured ? 'Ya' : 'Tidak',
            $news->is_headline ? 'Ya' : 'Tidak',
            $news->published_at ? $news->published_at->format('d/m/Y H:i') : '-',
            $news->created_at->format('d/m/Y H:i'),
        ];
    }

    /**
     * @param Worksheet $sheet
     */
    public function styles(Worksheet $sheet)
    {
        return [
            1 => [
                'font' => ['bold' => true],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '4F46E5']
                ],
                'font' => ['color' => ['rgb' => 'FFFFFF'], 'bold' => true],
            ],
        ];
    }

    /**
     * @return array
     */
    public function columnWidths(): array
    {
        return [
            'A' => 8,
            'B' => 40,
            'C' => 30,
            'D' => 15,
            'E' => 12,
            'F' => 20,
            'G' => 10,
            'H' => 12,
            'I' => 12,
            'J' => 20,
            'K' => 20,
        ];
    }
}
