<?php

namespace App\Imports;

use App\Models\MataPelajaran;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;

class MataPelajaranImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnFailure
{
    use SkipsFailures;

    protected $tahunAjaran;

    public function __construct($tahunAjaran)
    {
        $this->tahunAjaran = $tahunAjaran;
    }

    public function model(array $row)
    {
        return new MataPelajaran([
            'kode_mapel' => $row['kode_mapel'],
            'nama_mapel' => $row['nama_mapel'],
            'jtm' => $row['jtm'],
            'kkm' => $row['kkm'],
            'tingkat' => $row['tingkat'],
            'kelompok' => $row['kelompok'] ?? 'wajib',
            'tahun_ajaran' => $this->tahunAjaran,
            'is_active' => true,
        ]);
    }

    public function rules(): array
    {
        return [
            'kode_mapel' => 'required|string|unique:mata_pelajaran,kode_mapel',
            'nama_mapel' => 'required|string',
            'jtm' => 'required|integer|min:1|max:20',
            'kkm' => 'required|numeric|min:0|max:100',
            'tingkat' => 'required|in:MI,MTs,MA',
            'kelompok' => 'nullable|in:wajib,pilihan',
        ];
    }

    public function customValidationMessages()
    {
        return [
            'kode_mapel.required' => 'Kode mata pelajaran wajib diisi',
            'kode_mapel.unique' => 'Kode mata pelajaran sudah terdaftar',
            'nama_mapel.required' => 'Nama mata pelajaran wajib diisi',
            'jtm.required' => 'JTM wajib diisi',
            'jtm.integer' => 'JTM harus berupa angka',
            'jtm.min' => 'JTM minimal 1',
            'jtm.max' => 'JTM maksimal 20',
            'kkm.required' => 'KKM wajib diisi',
            'kkm.numeric' => 'KKM harus berupa angka',
            'kkm.min' => 'KKM minimal 0',
            'kkm.max' => 'KKM maksimal 100',
            'tingkat.required' => 'Tingkat wajib diisi',
            'tingkat.in' => 'Tingkat harus MI, MTs, atau MA',
            'kelompok.in' => 'Kelompok harus wajib atau pilihan',
        ];
    }
}
