<?php

namespace App\Imports;

use App\Models\Siswa;
use App\Models\User;
use App\Models\CounterNis;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;

class SiswaImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnFailure
{
    use SkipsFailures;

    public function model(array $row)
    {
        DB::beginTransaction();
        try {
            // Generate NIS otomatis
            $nis = CounterNis::generateNIS();

            // Create User
            $user = User::create([
                'name' => $row['nama'],
                'email' => $row['email'],
                'phone' => $row['telepon'] ?? null,
                'password' => Hash::make('Siswa123'),
                'role' => 'siswa',
                'is_active' => true,
            ]);

            // Create Siswa
            $siswa = new Siswa([
                'user_id' => $user->id,
                'nis' => $nis,
                'nisn' => $row['nisn'] ?? null,
                'kelas_id' => $row['kelas_id'] ?? null,
                'jenis_kelamin' => $row['jenis_kelamin'],
                'tempat_lahir' => $row['tempat_lahir'] ?? null,
                'tanggal_lahir' => isset($row['tanggal_lahir']) ? \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['tanggal_lahir'])->format('Y-m-d') : null,
                'alamat' => $row['alamat'] ?? null,
                'telepon' => $row['telepon'] ?? null,
                'nama_ayah' => $row['nama_ayah'] ?? null,
                'pekerjaan_ayah' => $row['pekerjaan_ayah'] ?? null,
                'nama_ibu' => $row['nama_ibu'] ?? null,
                'pekerjaan_ibu' => $row['pekerjaan_ibu'] ?? null,
                'nama_wali' => $row['nama_wali'] ?? null,
                'telepon_wali' => $row['telepon_wali'] ?? null,
                'alamat_wali' => $row['alamat_wali'] ?? null,
                'asal_sekolah' => $row['asal_sekolah'] ?? null,
                'tanggal_masuk' => isset($row['tanggal_masuk']) ? \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['tanggal_masuk'])->format('Y-m-d') : now(),
                'tahun_masuk' => $row['tahun_masuk'] ?? date('Y'),
                'status_siswa' => 'aktif',
                'catatan' => $row['catatan'] ?? null,
            ]);

            DB::commit();
            return $siswa;
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function rules(): array
    {
        return [
            'nama' => 'required|string',
            'email' => 'required|email|unique:users,email',
            'jenis_kelamin' => 'required|in:L,P',
        ];
    }

    public function customValidationMessages()
    {
        return [
            'nama.required' => 'Nama wajib diisi',
            'email.required' => 'Email wajib diisi',
            'email.email' => 'Format email tidak valid',
            'email.unique' => 'Email sudah terdaftar',
            'jenis_kelamin.required' => 'Jenis kelamin wajib diisi',
            'jenis_kelamin.in' => 'Jenis kelamin harus L atau P',
        ];
    }
}
