<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AttendanceSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'start_time_in',
        'end_time_in',
        'late_time_in',
        'start_time_out',
        'normal_time_out',
        'end_time_out',
        'location_lat',
        'location_lng',
        'max_radius',
        'require_photo',
        'require_location',
        'is_active',
    ];

    protected $casts = [
        'require_photo' => 'boolean',
        'require_location' => 'boolean',
        'is_active' => 'boolean',
        'location_lat' => 'float',
        'location_lng' => 'float',
        'max_radius' => 'integer',
    ];

    /**
     * Get the active attendance setting
     */
    public static function getActiveSetting()
    {
        return self::where('is_active', true)->first();
    }

    /**
     * Check if time is within check in range
     */
    public function isCheckInTime($time)
    {
        return $time >= $this->start_time_in && $time <= $this->late_time_in;
    }

    /**
     * Check if time is late for check in
     */
    public function isLateCheckIn($time)
    {
        return $time > $this->end_time_in && $time <= $this->late_time_in;
    }

    /**
     * Check if time is within check out range
     */
    public function isCheckOutTime($time)
    {
        return $time >= $this->start_time_out && $time <= $this->end_time_out;
    }

    /**
     * Get check in status based on time
     */
    public function getCheckInStatus($time)
    {
        if ($time <= $this->end_time_in) {
            return 'tepat_waktu';
        }
        return 'terlambat';
    }

    /**
     * Get check out status based on time
     */
    public function getCheckOutStatus($time)
    {
        if ($time < $this->start_time_out) {
            return 'lebih_awal';
        } elseif ($time > $this->end_time_out) {
            return 'lebih_lama';
        }
        return 'normal';
    }
}
