<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankSoal extends Model
{
    use HasFactory;

    protected $table = 'bank_soal';

    protected $fillable = [
        'guru_id',
        'mata_pelajaran_id',
        'judul',
        'topik',
        'kelas',
        'tingkat_kesulitan',
        'jumlah_pg',
        'jumlah_essay',
        'jumlah_isian',
        'jumlah_benar_salah',
        'file_soal',
        'file_kunci',
        'ai_prompt',
        'ai_response',
        'status',
    ];

    protected $casts = [
        'jumlah_pg' => 'integer',
        'jumlah_essay' => 'integer',
        'jumlah_isian' => 'integer',
        'jumlah_benar_salah' => 'integer',
    ];

    /**
     * Relasi ke Guru
     */
    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    /**
     * Relasi ke Mata Pelajaran
     */
    public function mataPelajaran()
    {
        return $this->belongsTo(MataPelajaran::class);
    }

    /**
     * Scope untuk filter berdasarkan guru
     */
    public function scopeByGuru($query, $guruId)
    {
        return $query->where('guru_id', $guruId);
    }

    /**
     * Scope untuk filter berdasarkan tingkat kesulitan
     */
    public function scopeByKesulitan($query, $kesulitan)
    {
        return $query->where('tingkat_kesulitan', $kesulitan);
    }

    /**
     * Get file soal URL
     */
    public function getFileSoalUrlAttribute()
    {
        if (!$this->file_soal) {
            return null;
        }
        return url($this->file_soal);
    }

    /**
     * Get file kunci URL
     */
    public function getFileKunciUrlAttribute()
    {
        if (!$this->file_kunci) {
            return null;
        }
        return url($this->file_kunci);
    }

    /**
     * Check if files exist
     */
    public function filesExist()
    {
        $soalExists = $this->file_soal && file_exists(public_path($this->file_soal));
        $kunciExists = $this->file_kunci && file_exists(public_path($this->file_kunci));
        return $soalExists && $kunciExists;
    }

    /**
     * Get total soal
     */
    public function getTotalSoalAttribute()
    {
        return $this->jumlah_pg + $this->jumlah_essay + $this->jumlah_isian + $this->jumlah_benar_salah;
    }
}
