<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CounterNis extends Model
{
    use HasFactory;

    protected $table = 'counter_nis';

    protected $fillable = [
        'tahun',
        'nomor_terakhir',
        'prefix_sekolah',
    ];

    /**
     * Generate NIS baru
     * Format: {prefix_sekolah}{tahun}{nomor_urut_3digit}
     * Contoh: 121262710001202500001
     */
    public static function generateNIS(): string
    {
        $tahun = date('Y');

        // Get atau create counter untuk tahun ini
        $counter = self::firstOrCreate(
            ['tahun' => $tahun],
            [
                'nomor_terakhir' => 0,
                'prefix_sekolah' => '121262710001'
            ]
        );

        // Increment nomor
        $counter->increment('nomor_terakhir');

        // Format: prefix + tahun + nomor (5 digit)
        $nis = $counter->prefix_sekolah . $tahun . str_pad($counter->nomor_terakhir, 5, '0', STR_PAD_LEFT);

        return $nis;
    }
}
