<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Guru extends Model
{
    use HasFactory;

    protected $table = 'guru';

    protected $fillable = [
        'user_id',
        'nip',
        'nuptk',
        'jenis_kelamin',
        'tempat_lahir',
        'tanggal_lahir',
        'alamat',
        'telepon',
        'status_kepegawaian',
        'pendidikan_terakhir',
        'jurusan',
        'mata_pelajaran',
        'tanggal_masuk',
        'status_aktif',
        'catatan',
    ];

    protected $casts = [
        'tanggal_lahir' => 'date',
        'tanggal_masuk' => 'date',
    ];

    /**
     * Relasi ke User
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Accessor untuk nama lengkap dari relasi user
     */
    public function getNamaAttribute()
    {
        return $this->user->name ?? '-';
    }

    /**
     * Accessor untuk email dari relasi user
     */
    public function getEmailAttribute()
    {
        return $this->user->email ?? '-';
    }
}
