<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JalurPendaftaran extends Model
{
    use HasFactory;

    protected $table = 'jalur_pendaftaran';

    protected $fillable = [
        'nama_jalur',
        'kode_jalur',
        'kuota',
        'keterangan',
        'is_active',
    ];

    protected $casts = [
        'kuota' => 'integer',
        'is_active' => 'boolean',
    ];

    /**
     * Relasi ke Pendaftaran Siswa
     */
    public function pendaftaran()
    {
        return $this->hasMany(PendaftaranSiswa::class, 'jalur_pendaftaran_id');
    }

    /**
     * Scope untuk jalur aktif
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Get sisa kuota
     */
    public function getSisaKuotaAttribute()
    {
        $terpakai = $this->pendaftaran()->count();
        return $this->kuota - $terpakai;
    }

    /**
     * Get persentase terisi
     */
    public function getPersentaseTerisiAttribute()
    {
        if ($this->kuota == 0) return 0;
        $terpakai = $this->pendaftaran()->count();
        return round(($terpakai / $this->kuota) * 100, 2);
    }
}
