<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kelas extends Model
{
    use HasFactory;

    protected $table = 'kelas';

    protected $fillable = [
        'nama_kelas',
        'tingkat',
        'wali_kelas_id',
        'kapasitas',
        'tahun_ajaran',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Relasi ke Wali Kelas (Guru)
     */
    public function waliKelas()
    {
        return $this->belongsTo(Guru::class, 'wali_kelas_id');
    }

    /**
     * Relasi ke Siswa
     */
    public function siswa()
    {
        return $this->hasMany(Siswa::class);
    }

    /**
     * Jumlah siswa aktif di kelas ini
     */
    public function jumlahSiswa()
    {
        return $this->siswa()->where('status_siswa', 'aktif')->count();
    }
}
