<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MataPelajaran extends Model
{
    use HasFactory;

    protected $table = 'mata_pelajaran';

    protected $fillable = [
        'kode_mapel',
        'nama_mapel',
        'jtm',
        'kkm',
        'tingkat',
        'kelompok',
        'tahun_ajaran',
        'is_active',
    ];

    protected $casts = [
        'jtm' => 'integer',
        'kkm' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    /**
     * Relasi ke GuruMengajar
     */
    public function guruMengajar()
    {
        return $this->hasMany(GuruMengajar::class, 'mata_pelajaran_id');
    }

    /**
     * Scope untuk filter berdasarkan tingkat
     */
    public function scopeTingkat($query, $tingkat)
    {
        return $query->where('tingkat', $tingkat);
    }

    /**
     * Scope untuk filter berdasarkan tahun ajaran
     */
    public function scopeTahunAjaran($query, $tahunAjaran)
    {
        return $query->where('tahun_ajaran', $tahunAjaran);
    }

    /**
     * Scope untuk mapel aktif
     */
    public function scopeAktif($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Get total JTM untuk tingkat tertentu
     */
    public static function getTotalJTM($tingkat, $tahunAjaran)
    {
        return self::where('tingkat', $tingkat)
            ->where('tahun_ajaran', $tahunAjaran)
            ->where('is_active', true)
            ->sum('jtm');
    }
}
