<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ModulAjar extends Model
{
    use HasFactory;

    protected $table = 'modul_ajar';

    protected $fillable = [
        'guru_id',
        'mata_pelajaran_id',
        'kelas',
        'fase',
        'judul',
        'topik',
        'jumlah_pertemuan',
        'alokasi_waktu',
        'jumlah_siswa',
        'kurikulum',
        'capaian_pembelajaran',
        'tujuan_pembelajaran',
        'profil_pelajar_pancasila',
        'model_pembelajaran',
        'file_path',
        'ai_prompt',
        'ai_response',
        'status',
    ];

    protected $casts = [
        'jumlah_pertemuan' => 'integer',
        'alokasi_waktu' => 'integer',
        'jumlah_siswa' => 'integer',
    ];

    /**
     * Relasi ke Guru
     */
    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    /**
     * Relasi ke Mata Pelajaran
     */
    public function mataPelajaran()
    {
        return $this->belongsTo(MataPelajaran::class);
    }

    /**
     * Scope untuk filter berdasarkan guru
     */
    public function scopeByGuru($query, $guruId)
    {
        return $query->where('guru_id', $guruId);
    }

    /**
     * Scope untuk filter berdasarkan kurikulum
     */
    public function scopeByKurikulum($query, $kurikulum)
    {
        return $query->where('kurikulum', $kurikulum);
    }

    /**
     * Scope untuk filter berdasarkan mata pelajaran
     */
    public function scopeByMapel($query, $mapelId)
    {
        return $query->where('mata_pelajaran_id', $mapelId);
    }

    /**
     * Get file URL
     */
    public function getFileUrlAttribute()
    {
        if (!$this->file_path) {
            return null;
        }
        return url($this->file_path);
    }

    /**
     * Check if file exists
     */
    public function fileExists()
    {
        if (!$this->file_path) {
            return false;
        }
        return file_exists(public_path($this->file_path));
    }
}
