<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PengaturanJam extends Model
{
    use HasFactory;

    protected $table = 'pengaturan_jam';

    protected $fillable = [
        'hari',
        'jam_ke',
        'jam_mulai',
        'jam_selesai',
        'durasi',
        'jenis_kegiatan',
        'tahun_ajaran',
    ];

    protected $casts = [
        'jam_ke' => 'integer',
        'durasi' => 'integer',
    ];

    /**
     * Relasi ke JadwalMengajar
     */
    public function jadwalMengajar()
    {
        return $this->hasMany(JadwalMengajar::class, 'pengaturan_jam_id');
    }

    /**
     * Scope untuk filter berdasarkan hari
     */
    public function scopeHari($query, $hari)
    {
        return $query->where('hari', $hari);
    }

    /**
     * Scope untuk filter berdasarkan tahun ajaran
     */
    public function scopeTahunAjaran($query, $tahunAjaran)
    {
        return $query->where('tahun_ajaran', $tahunAjaran);
    }

    /**
     * Scope untuk jam belajar saja
     */
    public function scopeBelajar($query)
    {
        return $query->where('jenis_kegiatan', 'belajar');
    }

    /**
     * Get total slot belajar per hari
     */
    public static function getTotalSlotBelajar($hari, $tahunAjaran)
    {
        return self::where('hari', $hari)
            ->where('jenis_kegiatan', 'belajar')
            ->where('tahun_ajaran', $tahunAjaran)
            ->count();
    }

    /**
     * Get total slot belajar semua hari
     */
    public static function getTotalSlotBelajarSeminggu($tahunAjaran)
    {
        return self::where('jenis_kegiatan', 'belajar')
            ->where('tahun_ajaran', $tahunAjaran)
            ->count();
    }
}
