<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PengaturanSPMB extends Model
{
    use HasFactory;

    protected $table = 'pengaturan_spmb';

    protected $fillable = [
        'key',
        'value',
        'type',
        'description',
    ];

    /**
     * Get value dengan cast sesuai type
     */
    public function getValueAttribute($value)
    {
        if ($this->type === 'json') {
            return json_decode($value, true);
        }

        if ($this->type === 'number') {
            return (float) $value;
        }

        return $value;
    }

    /**
     * Set value dengan encode jika json
     */
    public function setValueAttribute($value)
    {
        if ($this->type === 'json' && is_array($value)) {
            $this->attributes['value'] = json_encode($value);
        } else {
            $this->attributes['value'] = $value;
        }
    }

    /**
     * Helper untuk get setting by key
     */
    public static function getValue($key, $default = null)
    {
        $setting = self::where('key', $key)->first();
        return $setting ? $setting->value : $default;
    }

    /**
     * Helper untuk set setting
     */
    public static function setValue($key, $value, $type = 'text', $description = null)
    {
        return self::updateOrCreate(
            ['key' => $key],
            [
                'value' => $value,
                'type' => $type,
                'description' => $description,
            ]
        );
    }
}
