<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Siswa extends Model
{
    use HasFactory;

    protected $table = 'siswa';

    protected $fillable = [
        'user_id',
        'nis',
        'nisn',
        'kelas_id',
        'jenis_kelamin',
        'tempat_lahir',
        'tanggal_lahir',
        'alamat',
        'telepon',
        'nama_ayah',
        'pekerjaan_ayah',
        'nama_ibu',
        'pekerjaan_ibu',
        'nama_wali',
        'telepon_wali',
        'alamat_wali',
        'asal_sekolah',
        'tanggal_masuk',
        'tahun_masuk',
        'status_siswa',
        'tanggal_mutasi',
        'sekolah_tujuan',
        'sekolah_asal',
        'alasan_mutasi',
        'tanggal_lulus',
        'catatan',
    ];

    protected $casts = [
        'tanggal_lahir' => 'date',
        'tanggal_masuk' => 'date',
        'tanggal_mutasi' => 'date',
        'tanggal_lulus' => 'date',
    ];

    /**
     * Relasi ke User
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relasi ke Kelas
     */
    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }

    /**
     * Accessor untuk nama dari user
     */
    public function getNamaAttribute()
    {
        return $this->user->name ?? '-';
    }

    /**
     * Accessor untuk email dari user
     */
    public function getEmailAttribute()
    {
        return $this->user->email ?? '-';
    }

    /**
     * Scope untuk siswa aktif
     */
    public function scopeAktif($query)
    {
        return $query->where('status_siswa', 'aktif');
    }

    /**
     * Scope untuk siswa mutasi keluar
     */
    public function scopeMutasiKeluar($query)
    {
        return $query->where('status_siswa', 'mutasi_keluar');
    }

    /**
     * Scope untuk siswa mutasi masuk
     */
    public function scopeMutasiMasuk($query)
    {
        return $query->where('status_siswa', 'mutasi_masuk');
    }

    /**
     * Scope untuk siswa lulus
     */
    public function scopeLulus($query)
    {
        return $query->where('status_siswa', 'lulus');
    }
}
