<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guru', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('nip')->unique();
            $table->string('nuptk')->nullable();
            $table->enum('jenis_kelamin', ['L', 'P']);
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->text('alamat')->nullable();
            $table->string('telepon')->nullable();
            $table->enum('status_kepegawaian', ['PNS', 'PPPK', 'GTY', 'GTT'])->default('GTT');
            $table->string('pendidikan_terakhir')->nullable(); // S1, S2, S3
            $table->string('jurusan')->nullable();
            $table->string('mata_pelajaran')->nullable();
            $table->date('tanggal_masuk')->nullable();
            $table->enum('status_aktif', ['aktif', 'tidak_aktif', 'cuti'])->default('aktif');
            $table->text('catatan')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guru');
    }
};
