<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('siswa', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('nis')->unique();
            $table->string('nisn')->nullable();
            $table->foreignId('kelas_id')->nullable()->constrained('kelas')->onDelete('set null');

            // Data Pribadi
            $table->enum('jenis_kelamin', ['L', 'P']);
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->text('alamat')->nullable();
            $table->string('telepon')->nullable();

            // Data Orang Tua/Wali
            $table->string('nama_ayah')->nullable();
            $table->string('pekerjaan_ayah')->nullable();
            $table->string('nama_ibu')->nullable();
            $table->string('pekerjaan_ibu')->nullable();
            $table->string('nama_wali')->nullable();
            $table->string('telepon_wali')->nullable();
            $table->text('alamat_wali')->nullable();

            // Data Akademik
            $table->string('asal_sekolah')->nullable();
            $table->date('tanggal_masuk')->nullable();
            $table->string('tahun_masuk')->nullable(); // 2024

            // Status Siswa
            $table->enum('status_siswa', ['aktif', 'mutasi_keluar', 'mutasi_masuk', 'lulus', 'keluar'])->default('aktif');
            $table->date('tanggal_mutasi')->nullable();
            $table->string('sekolah_tujuan')->nullable(); // untuk mutasi keluar
            $table->string('sekolah_asal')->nullable(); // untuk mutasi masuk
            $table->text('alasan_mutasi')->nullable();
            $table->date('tanggal_lulus')->nullable();

            $table->text('catatan')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('siswa');
    }
};
