<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('mata_pelajaran', function (Blueprint $table) {
            $table->id();
            $table->string('kode_mapel')->unique();
            $table->string('nama_mapel');
            $table->integer('jtm'); // Jam Tatap Muka per minggu
            $table->decimal('kkm', 5, 2); // Kriteria Ketuntasan Minimal
            $table->enum('tingkat', ['MI', 'MTs', 'MA']); // MI=1-6, MTs=7-9, MA=10-12
            $table->enum('kelompok', ['wajib', 'pilihan'])->default('wajib');
            $table->string('tahun_ajaran'); // 2024/2025
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Index untuk performa query
            $table->index(['tingkat', 'tahun_ajaran']);
            $table->index(['is_active', 'tahun_ajaran']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('mata_pelajaran');
    }
};
