<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pengaturan_jam', function (Blueprint $table) {
            $table->id();
            $table->enum('hari', ['Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu']);
            $table->integer('jam_ke'); // 1, 2, 3, ...
            $table->time('jam_mulai'); // 06:30
            $table->time('jam_selesai'); // 07:10
            $table->integer('durasi'); // dalam menit (40, 35, 30, 25)
            $table->enum('jenis_kegiatan', [
                'belajar',
                'upacara',
                'istirahat',
                'kegiatan_pagi',
                'muhadhoroh'
            ]);
            $table->string('tahun_ajaran'); // 2024/2025
            $table->timestamps();

            // Unique constraint: tidak boleh ada jam yang sama di hari yang sama
            $table->unique(['hari', 'jam_ke', 'tahun_ajaran']);

            // Index untuk performa
            $table->index(['hari', 'jenis_kegiatan', 'tahun_ajaran']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pengaturan_jam');
    }
};
