<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('guru_mengajar', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guru_id')->constrained('guru')->onDelete('cascade');
            $table->foreignId('mata_pelajaran_id')->constrained('mata_pelajaran')->onDelete('cascade');
            $table->foreignId('kelas_id')->constrained('kelas')->onDelete('cascade');
            $table->string('tahun_ajaran'); // 2024/2025
            $table->timestamps();

            // Unique constraint: 1 guru tidak bisa ngajar mapel yang sama di kelas yang sama 2x
            $table->unique(['guru_id', 'mata_pelajaran_id', 'kelas_id', 'tahun_ajaran'], 'unique_guru_mapel_kelas');

            // Index untuk performa query
            $table->index(['guru_id', 'tahun_ajaran']);
            $table->index(['mata_pelajaran_id', 'tahun_ajaran']);
            $table->index(['kelas_id', 'tahun_ajaran']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('guru_mengajar');
    }
};
