<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('jadwal_mengajar', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guru_mengajar_id')->constrained('guru_mengajar')->onDelete('cascade');
            $table->foreignId('pengaturan_jam_id')->constrained('pengaturan_jam')->onDelete('cascade');
            $table->string('tahun_ajaran'); // 2024/2025
            $table->text('keterangan')->nullable(); // Catatan tambahan jika ada
            $table->timestamps();

            // Index untuk validasi anti-bentrok - NAMA DIPERPENDEK
            $table->index(['guru_mengajar_id', 'pengaturan_jam_id', 'tahun_ajaran'], 'idx_jadwal_guru_jam_ta');
            $table->index(['pengaturan_jam_id', 'tahun_ajaran'], 'idx_jadwal_jam_ta');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('jadwal_mengajar');
    }
};
