<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendance_settings', function (Blueprint $table) {
            $table->id();
            $table->time('start_time_in')->default('05:00:00')->comment('Awal waktu masuk');
            $table->time('end_time_in')->default('06:30:00')->comment('Batas waktu masuk tepat');
            $table->time('late_time_in')->default('10:30:00')->comment('Batas waktu masuk telat');
            $table->time('start_time_out')->default('10:30:00')->comment('Awal waktu pulang');
            $table->time('normal_time_out')->default('13:50:00')->comment('Waktu pulang normal');
            $table->time('end_time_out')->default('16:00:00')->comment('Batas waktu pulang');
            $table->decimal('location_lat', 10, 8)->nullable()->comment('Latitude lokasi sekolah');
            $table->decimal('location_lng', 11, 8)->nullable()->comment('Longitude lokasi sekolah');
            $table->integer('max_radius')->default(100)->comment('Radius maksimal dalam meter');
            $table->boolean('require_photo')->default(true)->comment('Wajib foto saat presensi');
            $table->boolean('require_location')->default(true)->comment('Wajib share lokasi');
            $table->boolean('is_active')->default(true)->comment('Status aktif');
            $table->timestamps();
        });

        // Insert default settings
        DB::table('attendance_settings')->insert([
            'start_time_in' => '05:00:00',
            'end_time_in' => '06:30:00',
            'late_time_in' => '10:30:00',
            'start_time_out' => '10:30:00',
            'normal_time_out' => '13:50:00',
            'end_time_out' => '16:00:00',
            'location_lat' => -2.21366625,
            'location_lng' => 113.94019526,
            'max_radius' => 100,
            'require_photo' => false,
            'require_location' => true,
            'is_active' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendance_settings');
    }
};
