<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guru_id')->constrained('guru')->onDelete('cascade');
            $table->date('date');

            // Check In
            $table->time('check_in_time')->nullable();
            $table->decimal('check_in_location_lat', 10, 8)->nullable();
            $table->decimal('check_in_location_lng', 11, 8)->nullable();
            $table->string('check_in_photo')->nullable();
            $table->enum('check_in_status', ['tepat_waktu', 'terlambat'])->nullable();

            // Check Out
            $table->time('check_out_time')->nullable();
            $table->decimal('check_out_location_lat', 10, 8)->nullable();
            $table->decimal('check_out_location_lng', 11, 8)->nullable();
            $table->string('check_out_photo')->nullable();
            $table->enum('check_out_status', ['normal', 'lebih_awal', 'lebih_lama'])->nullable();

            // Verification
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('verified_at')->nullable();
            $table->text('notes')->nullable();

            $table->timestamps();

            // Index untuk performa query
            $table->index(['guru_id', 'date']);
            $table->index('status');
            $table->index('date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};
