<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modul_ajar', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guru_id')->constrained('guru')->onDelete('cascade');
            $table->foreignId('mata_pelajaran_id')->constrained('mata_pelajaran')->onDelete('cascade');
            $table->string('kelas'); // 7A, 8B, dst
            $table->string('fase'); // A, B, C, D, E, F
            $table->string('judul');
            $table->text('topik');
            $table->integer('jumlah_pertemuan')->default(1);
            $table->integer('alokasi_waktu'); // dalam menit per pertemuan
            $table->integer('jumlah_siswa')->default(30);
            $table->enum('kurikulum', ['kurmer', 'berbasis_cinta'])->default('kurmer');
            $table->text('capaian_pembelajaran')->nullable();
            $table->text('tujuan_pembelajaran')->nullable();
            $table->text('profil_pelajar_pancasila')->nullable();
            $table->text('model_pembelajaran')->nullable();
            $table->string('file_path')->nullable(); // path to generated DOCX
            $table->text('ai_prompt')->nullable(); // store prompt yang digunakan
            $table->longText('ai_response')->nullable(); // store full response dari Gemini
            $table->enum('status', ['draft', 'generated', 'downloaded'])->default('draft');
            $table->timestamps();

            // Indexes
            $table->index(['guru_id', 'created_at']);
            $table->index(['mata_pelajaran_id', 'kelas']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('modul_ajar');
    }
};
