<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bank_soal', function (Blueprint $table) {
            $table->id();
            $table->foreignId('guru_id')->constrained('guru')->onDelete('cascade');
            $table->foreignId('mata_pelajaran_id')->constrained('mata_pelajaran')->onDelete('cascade');
            $table->string('judul');
            $table->text('topik');
            $table->string('kelas');
            $table->enum('tingkat_kesulitan', ['mudah', 'sedang', 'sulit'])->default('sedang');
            $table->integer('jumlah_pg')->default(0); // Pilihan Ganda
            $table->integer('jumlah_essay')->default(0);
            $table->integer('jumlah_isian')->default(0);
            $table->integer('jumlah_benar_salah')->default(0); // True/False
            $table->string('file_soal')->nullable(); // File soal (tanpa kunci)
            $table->string('file_kunci')->nullable(); // File kunci jawaban
            $table->text('ai_prompt')->nullable();
            $table->longText('ai_response')->nullable();
            $table->enum('status', ['draft', 'generated', 'downloaded'])->default('draft');
            $table->timestamps();

            // Indexes
            $table->index(['guru_id', 'created_at']);
            $table->index(['mata_pelajaran_id', 'kelas']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bank_soal');
    }
};
