<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('library_books', function (Blueprint $table) {
            $table->id();

            // Book Information
            $table->string('title');
            $table->string('author');
            $table->string('publisher')->nullable();
            $table->year('publication_year')->nullable();
            $table->string('isbn', 50)->nullable();
            $table->string('category', 100);
            $table->text('description')->nullable();
            $table->integer('pages')->nullable();
            $table->string('language', 50)->default('Indonesia');

            // Upload Method: 'upload' or 'link'
            $table->enum('file_type', ['upload', 'link'])->default('upload');

            // File Book (bisa file atau link)
            $table->string('file_path', 500)->nullable();
            $table->text('file_url')->nullable();
            $table->bigInteger('file_size')->nullable()->comment('Size in bytes');

            // Cover Image (bisa file atau link)
            $table->enum('cover_type', ['upload', 'link'])->default('upload');
            $table->string('cover_path', 500)->nullable();
            $table->text('cover_url')->nullable();

            // Metadata
            $table->integer('views_count')->default(0);
            $table->integer('downloads_count')->default(0);
            $table->enum('status', ['available', 'maintenance', 'unavailable'])->default('available');
            $table->boolean('is_featured')->default(false);

            // Timestamps & User Tracking
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();

            // Foreign Keys
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');

            // Indexes
            $table->index('category');
            $table->index('status');
            $table->index('publication_year');
            $table->fullText(['title', 'author', 'description']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('library_books');
    }
};
