<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('periode_spmb', function (Blueprint $table) {
            $table->id();
            $table->string('tahun_ajaran', 20); // 2025/2026
            $table->integer('gelombang')->default(1); // 1, 2, 3
            $table->date('tanggal_mulai');
            $table->date('tanggal_selesai');
            $table->decimal('biaya_pendaftaran', 15, 2)->default(0);
            $table->integer('kuota_total')->default(0);
            $table->enum('status', ['aktif', 'tidak_aktif'])->default('tidak_aktif');
            $table->text('keterangan')->nullable();
            $table->timestamps();

            // Index untuk performa
            $table->index('status');
            $table->index(['tahun_ajaran', 'gelombang']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('periode_spmb');
    }
};
