<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pendaftaran_siswa', function (Blueprint $table) {
            $table->id();
            $table->foreignId('periode_spmb_id')->constrained('periode_spmb')->onDelete('cascade');
            $table->foreignId('jalur_pendaftaran_id')->constrained('jalur_pendaftaran')->onDelete('cascade');
            $table->string('nomor_pendaftaran', 50)->unique(); // SPMB-2025-0001
            $table->date('tanggal_daftar');

            // Data Pribadi
            $table->string('nama_lengkap');
            $table->string('nik', 16)->nullable();
            $table->string('nisn', 10)->nullable();
            $table->enum('jenis_kelamin', ['L', 'P']);
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->string('agama', 50)->nullable();
            $table->integer('anak_ke')->nullable();
            $table->integer('jumlah_saudara')->nullable();
            $table->text('alamat')->nullable();
            $table->string('rt', 5)->nullable();
            $table->string('rw', 5)->nullable();
            $table->string('kelurahan', 100)->nullable();
            $table->string('kecamatan', 100)->nullable();
            $table->string('kabupaten', 100)->nullable();
            $table->string('provinsi', 100)->nullable();
            $table->string('kode_pos', 10)->nullable();
            $table->string('telepon', 20)->nullable();
            $table->string('email')->nullable();

            // Data Orang Tua
            $table->string('nama_ayah')->nullable();
            $table->string('nik_ayah', 16)->nullable();
            $table->string('pekerjaan_ayah')->nullable();
            $table->string('penghasilan_ayah', 50)->nullable();
            $table->string('telepon_ayah', 20)->nullable();

            $table->string('nama_ibu')->nullable();
            $table->string('nik_ibu', 16)->nullable();
            $table->string('pekerjaan_ibu')->nullable();
            $table->string('penghasilan_ibu', 50)->nullable();
            $table->string('telepon_ibu', 20)->nullable();

            // Data Wali (Opsional)
            $table->string('nama_wali')->nullable();
            $table->string('nik_wali', 16)->nullable();
            $table->string('pekerjaan_wali')->nullable();
            $table->string('penghasilan_wali', 50)->nullable();
            $table->string('telepon_wali', 20)->nullable();
            $table->string('hubungan_wali', 50)->nullable();

            // Data Sekolah Asal
            $table->string('asal_sekolah')->nullable();
            $table->string('npsn_sekolah', 20)->nullable();
            $table->text('alamat_sekolah')->nullable();
            $table->string('tahun_lulus', 4)->nullable();

            // Status & Verifikasi
            $table->enum('status_pendaftaran', [
                'baru',
                'verifikasi_berkas',
                'verifikasi_pembayaran',
                'diterima',
                'ditolak'
            ])->default('baru');
            $table->text('catatan_verifikasi')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('verified_at')->nullable();
            // Status Konversi ke Siswa
            $table->boolean('is_converted_to_siswa')->default(false);
            $table->foreignId('siswa_id')->nullable()->constrained('siswa')->onDelete('set null');
            $table->timestamp('converted_at')->nullable();

            $table->timestamps();

            // Indexes
            $table->index('nomor_pendaftaran');
            $table->index('status_pendaftaran');
            $table->index('email');
            $table->index('tanggal_daftar');
            $table->index(['periode_spmb_id', 'jalur_pendaftaran_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pendaftaran_siswa');
    }
};
