<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('dokumen_pendaftaran', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pendaftaran_siswa_id')->constrained('pendaftaran_siswa')->onDelete('cascade');
            $table->enum('jenis_dokumen', [
                'foto',
                'ijazah',
                'kartu_keluarga',
                'akta_kelahiran',
                'bukti_pembayaran',
                'surat_pernyataan',
                'sertifikat_prestasi',
                'surat_keterangan_tidak_mampu'
            ]);
            $table->string('nama_file');
            $table->string('file_path');
            $table->integer('ukuran_file')->comment('Size in bytes');
            $table->enum('status_verifikasi', ['pending', 'valid', 'tidak_valid'])->default('pending');
            $table->text('catatan_verifikasi')->nullable();
            $table->timestamps();

            // Indexes
            $table->index('pendaftaran_siswa_id');
            $table->index('jenis_dokumen');
            $table->index('status_verifikasi');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('dokumen_pendaftaran');
    }
};
