<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Kelas;

class KelasSeeder extends Seeder
{
    public function run(): void
    {
        $tahunAjaran = '2024/2025';

        $kelasData = [
            // Kelas 7
            ['nama_kelas' => '7A', 'tingkat' => '7'],
            ['nama_kelas' => '7B', 'tingkat' => '7'],
            ['nama_kelas' => '7C', 'tingkat' => '7'],

            // Kelas 8
            ['nama_kelas' => '8A', 'tingkat' => '8'],
            ['nama_kelas' => '8B', 'tingkat' => '8'],
            ['nama_kelas' => '8C', 'tingkat' => '8'],

            // Kelas 9
            ['nama_kelas' => '9A', 'tingkat' => '9'],
            ['nama_kelas' => '9B', 'tingkat' => '9'],
            ['nama_kelas' => '9C', 'tingkat' => '9'],
        ];

        foreach ($kelasData as $kelas) {
            Kelas::create([
                'nama_kelas' => $kelas['nama_kelas'],
                'tingkat' => $kelas['tingkat'],
                'tahun_ajaran' => $tahunAjaran,
                'kapasitas' => 30,
                'is_active' => true,
            ]);
        }
    }
}
