<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\LibraryBook;
use App\Models\User;

class LibraryBookSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::where('role', 'admin')->first();

        if (!$admin) {
            $this->command->warn('Admin user not found. Please create admin user first.');
            return;
        }

        $books = [
            [
                'title' => 'Al-Quran dan Terjemahannya',
                'author' => 'Kementerian Agama RI',
                'publisher' => 'Kemenag RI',
                'publication_year' => 2023,
                'isbn' => '978-602-1234-56-7',
                'category' => 'Agama Islam',
                'description' => 'Al-Quran lengkap dengan terjemahan bahasa Indonesia',
                'pages' => 604,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://quran.kemenag.go.id/assets/pdf/Al-Quran.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1609599006353-e629aaabfeae?w=800',
                'status' => 'available',
                'is_featured' => true,
            ],
            [
                'title' => 'Hadits Shahih Bukhari',
                'author' => 'Imam Bukhari',
                'publisher' => 'Pustaka Azzam',
                'publication_year' => 2022,
                'isbn' => '978-602-1234-57-8',
                'category' => 'Agama Islam',
                'description' => 'Kumpulan hadits shahih dari Imam Bukhari',
                'pages' => 850,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/bukhari.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1585522969433-cf74c1cc8ef5?w=800',
                'status' => 'available',
                'is_featured' => true,
            ],
            [
                'title' => 'Matematika Dasar SMP',
                'author' => 'Dr. Ahmad Fauzi',
                'publisher' => 'Erlangga',
                'publication_year' => 2024,
                'isbn' => '978-602-1234-58-9',
                'category' => 'Akademik',
                'description' => 'Buku matematika untuk siswa SMP kelas 7-9',
                'pages' => 320,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/matematika-smp.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1596495577886-d920f1fb7238?w=800',
                'status' => 'available',
                'is_featured' => false,
            ],
            [
                'title' => 'Bahasa Indonesia untuk SMP',
                'author' => 'Prof. Siti Nurhaliza',
                'publisher' => 'Gramedia',
                'publication_year' => 2024,
                'isbn' => '978-602-1234-59-0',
                'category' => 'Akademik',
                'description' => 'Panduan lengkap bahasa Indonesia tingkat SMP',
                'pages' => 280,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/bahasa-indonesia.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1456513080510-7bf3a84b82f8?w=800',
                'status' => 'available',
                'is_featured' => false,
            ],
            [
                'title' => 'Sejarah Islam di Indonesia',
                'author' => 'Dr. Muhammad Yusuf',
                'publisher' => 'Mizan',
                'publication_year' => 2023,
                'isbn' => '978-602-1234-60-6',
                'category' => 'Sejarah',
                'description' => 'Perjalanan Islam di Nusantara dari masa ke masa',
                'pages' => 450,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/sejarah-islam.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1524995997946-a1c2e315a42f?w=800',
                'status' => 'available',
                'is_featured' => true,
            ],
            [
                'title' => 'Ensiklopedia Sains',
                'author' => 'Tim Penulis Sains',
                'publisher' => 'Erlangga',
                'publication_year' => 2024,
                'isbn' => '978-602-1234-61-7',
                'category' => 'Sains & Teknologi',
                'description' => 'Ensiklopedia lengkap tentang dunia sains',
                'pages' => 600,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/ensiklopedia-sains.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1507842217343-583bb7270b66?w=800',
                'status' => 'available',
                'is_featured' => false,
            ],
            [
                'title' => 'Laskar Pelangi',
                'author' => 'Andrea Hirata',
                'publisher' => 'Bentang Pustaka',
                'publication_year' => 2005,
                'isbn' => '978-979-1227-78-0',
                'category' => 'Fiksi',
                'description' => 'Novel inspiratif tentang perjuangan anak-anak di Belitung',
                'pages' => 529,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/laskar-pelangi.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1544947950-fa07a98d237f?w=800',
                'status' => 'available',
                'is_featured' => true,
            ],
            [
                'title' => 'Akhlak Mulia dalam Islam',
                'author' => 'Ustadz Abdul Somad',
                'publisher' => 'Pustaka Al-Kautsar',
                'publication_year' => 2023,
                'isbn' => '978-602-1234-62-8',
                'category' => 'Agama Islam',
                'description' => 'Panduan membangun akhlak mulia berdasarkan ajaran Islam',
                'pages' => 250,
                'language' => 'Indonesia',
                'file_type' => 'link',
                'file_url' => 'https://example.com/akhlak-mulia.pdf',
                'cover_type' => 'link',
                'cover_url' => 'https://images.unsplash.com/photo-1512820790803-83ca734da794?w=800',
                'status' => 'available',
                'is_featured' => false,
            ],
        ];

        foreach ($books as $book) {
            $book['created_by'] = $admin->id;
            $book['updated_by'] = $admin->id;
            $book['views_count'] = rand(10, 500);
            $book['downloads_count'] = rand(5, 200);

            LibraryBook::create($book);
        }

        $this->command->info('Library books seeded successfully!');
    }
}
