<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\PengaturanSPMB;

class PengaturanSPMBSeeder extends Seeder
{
    public function run(): void
    {
        // Syarat & Ketentuan
        PengaturanSPMB::create([
            'key' => 'syarat_ketentuan',
            'value' => "1. Berusia maksimal 15 tahun pada 1 Juli 2025\n2. Lulus SD/MI atau sederajat\n3. Memiliki ijazah atau surat keterangan lulus\n4. Sehat jasmani dan rohani\n5. Tidak buta warna (untuk jurusan tertentu)",
            'type' => 'text',
            'description' => 'Syarat dan ketentuan pendaftaran SPMB',
        ]);

        // Informasi Pembayaran
        PengaturanSPMB::create([
            'key' => 'informasi_pembayaran',
            'value' => "Biaya pendaftaran: Rp 250.000,-\n\nMetode Pembayaran:\n- Transfer Bank\n- Tunai ke Bendahara\n\nSetelah pembayaran, upload bukti transfer pada form pendaftaran.",
            'type' => 'text',
            'description' => 'Informasi biaya dan cara pembayaran',
        ]);

        // Rekening Bank
        PengaturanSPMB::create([
            'key' => 'rekening_bank',
            'value' => json_encode([
                [
                    'bank' => 'BRI',
                    'nomor_rekening' => '1234567890',
                    'atas_nama' => 'BENDAHARA MADRASAH',
                ],
                [
                    'bank' => 'BNI',
                    'nomor_rekening' => '0987654321',
                    'atas_nama' => 'BENDAHARA MADRASAH',
                ],
            ]),
            'type' => 'json',
            'description' => 'Daftar rekening bank untuk pembayaran',
        ]);

        // Contact Person
        PengaturanSPMB::create([
            'key' => 'contact_person',
            'value' => json_encode([
                [
                    'nama' => 'Ibu Siti',
                    'jabatan' => 'Staff TU',
                    'telepon' => '081234567890',
                ],
                [
                    'nama' => 'Bapak Ahmad',
                    'jabatan' => 'Koordinator SPMB',
                    'telepon' => '081987654321',
                ],
            ]),
            'type' => 'json',
            'description' => 'Contact person untuk informasi SPMB',
        ]);

        // Alur Pendaftaran
        PengaturanSPMB::create([
            'key' => 'alur_pendaftaran',
            'value' => "1. Isi formulir pendaftaran online\n2. Upload dokumen persyaratan\n3. Lakukan pembayaran\n4. Upload bukti pembayaran\n5. Tunggu verifikasi dari admin\n6. Cek status pendaftaran secara berkala",
            'type' => 'text',
            'description' => 'Alur proses pendaftaran SPMB',
        ]);

        // Banner Image (opsional)
        PengaturanSPMB::create([
            'key' => 'banner_image',
            'value' => null,
            'type' => 'image',
            'description' => 'Banner image untuk halaman SPMB',
        ]);

        // Waktu Operasional
        PengaturanSPMB::create([
            'key' => 'waktu_operasional',
            'value' => "Senin - Jumat: 08.00 - 15.00 WIB\nSabtu: 08.00 - 12.00 WIB\nMinggu & Libur: Tutup",
            'type' => 'text',
            'description' => 'Waktu operasional pelayanan SPMB',
        ]);

        // Lokasi Pendaftaran
        PengaturanSPMB::create([
            'key' => 'lokasi_pendaftaran',
            'value' => "Madrasah Tsanawiyah Negeri\nJl. Pendidikan No. 123\nKota, Provinsi 12345",
            'type' => 'text',
            'description' => 'Alamat lokasi pendaftaran offline',
        ]);
    }
}
