<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'name' => 'Abinyawafa',
                'email' => 'admin@simmada.com',
                'phone' => '081234567890', // Tambahkan phone
                'password' => Hash::make('password'),
                'role' => 'admin',
                'photo' => null, // Will use default avatar
                'is_active' => true,
            ],
            [
                'name' => 'Mukhlis Padilah, S.Pd.I',
                'email' => 'staff@simmada.com',
                'phone' => '081234567891', // Tambahkan phone
                'password' => Hash::make('password'),
                'role' => 'staff',
                'is_active' => true,
            ],
            [
                'name' => 'Kepala Madrasah',
                'email' => 'kepala@simmada.com',
                'phone' => '0811138000859', // Tambahkan phone
                'password' => Hash::make('password'),
                'role' => 'kepala',
                'is_active' => true,
            ],
            [
                'name' => 'Bendahara',
                'email' => 'bendahara@simmada.com',
                'phone' => '081234567893', // Tambahkan phone
                'password' => Hash::make('password'),
                'role' => 'bendahara',
                'is_active' => true,
            ],
            [
                'name' => 'Guru Contoh',
                'email' => 'guru@simmada.com',
                'phone' => '081234567894', // Tambahkan phone
                'password' => Hash::make('password'),
                'role' => 'guru',
                'is_active' => true,
            ],
            [
                'name' => 'Siswa Contoh',
                'email' => 'siswa@simmada.com',
                'phone' => '081234567895', // Tambahkan phone
                'password' => Hash::make('password'),
                'role' => 'siswa',
                'is_active' => true,
            ],
        ];

        foreach ($users as $user) {
            User::create($user);
        }
    }
}
