<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\GuruController;
use App\Http\Controllers\Api\SiswaController;
use App\Http\Controllers\Api\KelasController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\MataPelajaranController;
use App\Http\Controllers\Api\PengaturanJamController;
use App\Http\Controllers\Api\GuruMengajarController;
use App\Http\Controllers\Api\JadwalMengajarController;
use App\Http\Controllers\Api\AttendanceController;
use App\Http\Controllers\Api\Guru\GuruAttendanceController;
use App\Http\Controllers\Api\Guru\ModulAjarController;
use App\Http\Controllers\Api\Guru\BankSoalController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\LibraryBookController;
use App\Http\Controllers\Api\NewsController;
use App\Http\Controllers\Api\PublicNewsController;
use App\Http\Controllers\Api\SPMBController;
use App\Http\Controllers\Api\Public\SPMBController as PublicSPMBController;

// Public routes
Route::post('/login', [AuthController::class, 'login']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);

// Public Library Routes (dapat diakses tanpa login)
Route::prefix('public/library')->group(function () {
    Route::get('/', [LibraryBookController::class, 'index']);
    Route::get('/categories', [LibraryBookController::class, 'categories']);
    Route::get('/statistics', [LibraryBookController::class, 'statistics']);
    Route::get('/{id}', [LibraryBookController::class, 'show']);
    Route::post('/{id}/increment-views', [LibraryBookController::class, 'incrementViews']);
    Route::post('/{id}/increment-downloads', [LibraryBookController::class, 'incrementDownloads']);
});

// Public News Routes
Route::prefix('public/news')->group(function () {
    Route::get('/', [PublicNewsController::class, 'index']);
    Route::get('/headline', [PublicNewsController::class, 'getHeadline']);
    Route::get('/featured', [PublicNewsController::class, 'getFeatured']);
    Route::get('/popular', [PublicNewsController::class, 'getPopular']);
    Route::get('/categories', [PublicNewsController::class, 'getCategories']);
    Route::get('/category/{category}', [PublicNewsController::class, 'getByCategory']);
    Route::get('/{slug}', [PublicNewsController::class, 'show']);
    Route::post('/{id}/increment-views', [PublicNewsController::class, 'incrementViews']);
});

// Public SPMB Routes
Route::prefix('public/spmb')->group(function () {
    Route::get('/info', [PublicSPMBController::class, 'getInfo']);
    Route::get('/periode-aktif', [PublicSPMBController::class, 'getPeriodeAktif']);
    Route::get('/jalur', [PublicSPMBController::class, 'getJalur']);
    Route::post('/daftar', [PublicSPMBController::class, 'daftar']);
    Route::get('/cek-status/{nomor}', [PublicSPMBController::class, 'cekStatus']);
});

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/me', [AuthController::class, 'me']);

    // Admin routes
    Route::prefix('admin')->group(function () {
        // User Management (only admin/staff/kepala/bendahara)
        Route::apiResource('users', UserController::class);
        Route::post('users/{id}/reset-password', [UserController::class, 'resetPassword']);
        Route::post('users/{id}/toggle-status', [UserController::class, 'toggleStatus']);

        // Guru Management
        Route::apiResource('guru', GuruController::class);
        Route::post('guru/import', [GuruController::class, 'import']);
        Route::get('guru/export/excel', [GuruController::class, 'export']);
        Route::get('guru/download/template', [GuruController::class, 'downloadTemplate']);

        // Siswa Management
        Route::apiResource('siswa', SiswaController::class);
        Route::post('siswa/import', [SiswaController::class, 'import']);
        Route::get('siswa/export/excel', [SiswaController::class, 'export']);
        Route::get('siswa/download/template', [SiswaController::class, 'downloadTemplate']);
        Route::post('siswa/{id}/mutasi-keluar', [SiswaController::class, 'mutasiKeluar']);
        Route::post('siswa/{id}/update-status', [SiswaController::class, 'updateStatus']);

        // Kelas Management
        Route::apiResource('kelas', KelasController::class);
        Route::get('kelas/list/all', [KelasController::class, 'listAll']);

        // Mata Pelajaran Management
        Route::apiResource('mata-pelajaran', MataPelajaranController::class);
        Route::post('mata-pelajaran/import/excel', [MataPelajaranController::class, 'import']);
        Route::get('mata-pelajaran/export/excel', [MataPelajaranController::class, 'export']);
        Route::get('mata-pelajaran/download/template', [MataPelajaranController::class, 'downloadTemplate']);
        Route::get('mata-pelajaran/statistics/data', [MataPelajaranController::class, 'statistics']);

        // Pengaturan Jam Management
        Route::apiResource('pengaturan-jam', PengaturanJamController::class);
        Route::post('pengaturan-jam/generate/auto', [PengaturanJamController::class, 'generateJam']);
        Route::get('pengaturan-jam/statistics/data', [PengaturanJamController::class, 'statistics']);

        // Guru Mengajar Management
        Route::apiResource('guru-mengajar', GuruMengajarController::class);
        Route::post('guru-mengajar/import/excel', [GuruMengajarController::class, 'import']);
        Route::get('guru-mengajar/export/excel', [GuruMengajarController::class, 'export']);
        Route::get('guru-mengajar/download/template', [GuruMengajarController::class, 'downloadTemplate']);
        Route::get('guru-mengajar/by-guru/{guruId}', [GuruMengajarController::class, 'byGuru']);
        Route::get('guru-mengajar/by-kelas/{kelasId}', [GuruMengajarController::class, 'byKelas']);
        Route::get('guru-mengajar/statistics/data', [GuruMengajarController::class, 'statistics']);

        // Jadwal Mengajar Management
        Route::prefix('jadwal-mengajar')->group(function () {
            Route::get('statistics/data', [JadwalMengajarController::class, 'statistics']);
            Route::get('by-kelas/{kelasId}', [JadwalMengajarController::class, 'byKelas']);
            Route::get('by-guru/{guruId}', [JadwalMengajarController::class, 'byGuru']);
            Route::delete('delete-by-kelas/{kelasId}', [JadwalMengajarController::class, 'deleteByKelas']);
        });
        Route::apiResource('jadwal-mengajar', JadwalMengajarController::class);

        // Attendance Management
        Route::prefix('attendance')->group(function () {
            Route::get('/', [AttendanceController::class, 'index']);
            Route::get('/statistics', [AttendanceController::class, 'statistics']);
            Route::get('/export', [AttendanceController::class, 'export']);
            Route::get('/{id}', [AttendanceController::class, 'show']);
            Route::post('/{id}/approve', [AttendanceController::class, 'approve']);
            Route::post('/{id}/reject', [AttendanceController::class, 'reject']);

            // Settings
            Route::get('/settings/get', [AttendanceController::class, 'getSettings']);
            Route::put('/settings/update', [AttendanceController::class, 'updateSettings']);
        });

        // Library Digital Management (Admin & Staff)
        Route::prefix('library')->group(function () {
            Route::get('/', [LibraryBookController::class, 'index']);
            Route::post('/', [LibraryBookController::class, 'store']);
            Route::get('/statistics', [LibraryBookController::class, 'statistics']);
            Route::get('/categories', [LibraryBookController::class, 'categories']);
            Route::get('/export', [LibraryBookController::class, 'export']);
            Route::get('/{id}', [LibraryBookController::class, 'show']);
            Route::post('/{id}', [LibraryBookController::class, 'update']); // Using POST for file upload
            Route::delete('/{id}', [LibraryBookController::class, 'destroy']);
            Route::post('/{id}/toggle-featured', [LibraryBookController::class, 'toggleFeatured']);
            Route::post('/{id}/increment-views', [LibraryBookController::class, 'incrementViews']);
            Route::post('/{id}/increment-downloads', [LibraryBookController::class, 'incrementDownloads']);
        });

        // News Management
        Route::prefix('news')->group(function () {
            Route::get('/statistics', [NewsController::class, 'statistics']);
            Route::get('/export', [NewsController::class, 'export']);
            Route::post('/{id}/toggle-featured', [NewsController::class, 'toggleFeatured']);
            Route::post('/{id}/toggle-headline', [NewsController::class, 'toggleHeadline']);
            Route::post('/{id}/change-status', [NewsController::class, 'changeStatus']);
        });
        Route::apiResource('news', NewsController::class);

        // SPMB Management
        Route::prefix('spmb')->group(function () {
            // Dashboard
            Route::get('/dashboard', [SPMBController::class, 'getDashboard']);

            // Pendaftaran Management
            Route::get('/pendaftaran', [SPMBController::class, 'index']);
            Route::get('/pendaftaran/{id}', [SPMBController::class, 'show']);
            Route::post('/pendaftaran/{id}/verifikasi-dokumen', [SPMBController::class, 'verifikasiDokumen']);
            Route::post('/pendaftaran/{id}/terima', [SPMBController::class, 'terimaPendaftaran']);
            Route::post('/pendaftaran/{id}/tolak', [SPMBController::class, 'tolakPendaftaran']);
            Route::delete('/pendaftaran/{id}', [SPMBController::class, 'destroy']);
            Route::get('/pendaftaran/export/excel', [SPMBController::class, 'exportPendaftaran']);

            // Convert to Siswa
            Route::post('/pendaftaran/{id}/convert-to-siswa', [SPMBController::class, 'convertToSiswa']);
            Route::post('/pendaftaran/batch-convert', [SPMBController::class, 'batchConvertToSiswa']);

            // Periode SPMB Management
            Route::get('/periode', [SPMBController::class, 'getPeriode']);
            Route::post('/periode', [SPMBController::class, 'storePeriode']);
            Route::put('/periode/{id}', [SPMBController::class, 'updatePeriode']);
            Route::delete('/periode/{id}', [SPMBController::class, 'deletePeriode']);

            // Jalur Pendaftaran Management
            Route::get('/jalur', [SPMBController::class, 'getJalur']);
            Route::post('/jalur', [SPMBController::class, 'storeJalur']);
            Route::put('/jalur/{id}', [SPMBController::class, 'updateJalur']);
            Route::delete('/jalur/{id}', [SPMBController::class, 'deleteJalur']);

            // Pengaturan SPMB
            Route::get('/pengaturan', [SPMBController::class, 'getPengaturan']);
            Route::put('/pengaturan', [SPMBController::class, 'updatePengaturan']);
        });
    });

    // Staff routes
    Route::prefix('staff')->group(function () {
        // Library Digital for Staff (same as admin)
        Route::prefix('library')->group(function () {
            Route::get('/', [LibraryBookController::class, 'index']);
            Route::post('/', [LibraryBookController::class, 'store']);
            Route::get('/statistics', [LibraryBookController::class, 'statistics']);
            Route::get('/categories', [LibraryBookController::class, 'categories']);
            Route::get('/export', [LibraryBookController::class, 'export']);
            Route::get('/{id}', [LibraryBookController::class, 'show']);
            Route::post('/{id}', [LibraryBookController::class, 'update']);
            Route::delete('/{id}', [LibraryBookController::class, 'destroy']);
            Route::post('/{id}/toggle-featured', [LibraryBookController::class, 'toggleFeatured']);
        });

        // News Management for Staff
        Route::prefix('news')->group(function () {
            Route::get('/', [NewsController::class, 'index']);
            Route::post('/', [NewsController::class, 'store']);
            Route::get('/statistics', [NewsController::class, 'statistics']);
            Route::get('/export', [NewsController::class, 'export']);
            Route::get('/{id}', [NewsController::class, 'show']);
            Route::post('/{id}', [NewsController::class, 'update']);
            Route::delete('/{id}', [NewsController::class, 'destroy']);
            Route::post('/{id}/toggle-featured', [NewsController::class, 'toggleFeatured']);
            Route::post('/{id}/toggle-headline', [NewsController::class, 'toggleHeadline']);
            Route::post('/{id}/change-status', [NewsController::class, 'changeStatus']);
        });

        // SPMB Management for Staff (same as admin)
        Route::prefix('spmb')->group(function () {
            Route::get('/dashboard', [SPMBController::class, 'getDashboard']);
            Route::get('/pendaftaran', [SPMBController::class, 'index']);
            Route::get('/pendaftaran/{id}', [SPMBController::class, 'show']);
            Route::post('/pendaftaran/{id}/verifikasi-dokumen', [SPMBController::class, 'verifikasiDokumen']);
            Route::post('/pendaftaran/{id}/terima', [SPMBController::class, 'terimaPendaftaran']);
            Route::post('/pendaftaran/{id}/tolak', [SPMBController::class, 'tolakPendaftaran']);
            Route::delete('/pendaftaran/{id}', [SPMBController::class, 'destroy']);
            Route::get('/pendaftaran/export/excel', [SPMBController::class, 'exportPendaftaran']);
            Route::post('/pendaftaran/{id}/convert-to-siswa', [SPMBController::class, 'convertToSiswa']);
            Route::post('/pendaftaran/batch-convert', [SPMBController::class, 'batchConvertToSiswa']);
            Route::get('/periode', [SPMBController::class, 'getPeriode']);
            Route::post('/periode', [SPMBController::class, 'storePeriode']);
            Route::put('/periode/{id}', [SPMBController::class, 'updatePeriode']);
            Route::delete('/periode/{id}', [SPMBController::class, 'deletePeriode']);
            Route::get('/jalur', [SPMBController::class, 'getJalur']);
            Route::post('/jalur', [SPMBController::class, 'storeJalur']);
            Route::put('/jalur/{id}', [SPMBController::class, 'updateJalur']);
            Route::delete('/jalur/{id}', [SPMBController::class, 'deleteJalur']);
            Route::get('/pengaturan', [SPMBController::class, 'getPengaturan']);
            Route::put('/pengaturan', [SPMBController::class, 'updatePengaturan']);
        });
    });

    Route::prefix('kepala')->group(function () {
        // Kepala routes will be here
    });

    Route::prefix('bendahara')->group(function () {
        // Bendahara routes will be here
    });

    Route::prefix('guru')->group(function () {
        // Guru Attendance
        Route::prefix('attendance')->group(function () {
            Route::get('/today', [GuruAttendanceController::class, 'getTodayStatus']);
            Route::post('/check-in', [GuruAttendanceController::class, 'checkIn']);
            Route::post('/check-out', [GuruAttendanceController::class, 'checkOut']);
            Route::get('/history', [GuruAttendanceController::class, 'getHistory']);
            Route::get('/statistics', [GuruAttendanceController::class, 'getStatistics']);
        });

        // Modul Ajar (AI Generator)
        Route::prefix('modul-ajar')->group(function () {
            Route::get('/statistics', [ModulAjarController::class, 'statistics']);
            Route::get('/mata-pelajaran-options', [ModulAjarController::class, 'getMataPelajaranOptions']);
            Route::get('/', [ModulAjarController::class, 'index']);
            Route::post('/', [ModulAjarController::class, 'store']);
            Route::get('/{id}', [ModulAjarController::class, 'show']);
            Route::get('/{id}/download', [ModulAjarController::class, 'download']);
            Route::delete('/{id}', [ModulAjarController::class, 'destroy']);
        });

        // Bank Soal (AI Quiz Generator)
        Route::prefix('bank-soal')->group(function () {
            Route::get('/statistics', [BankSoalController::class, 'statistics']);
            Route::get('/', [BankSoalController::class, 'index']);
            Route::post('/', [BankSoalController::class, 'store']);
            Route::get('/{id}', [BankSoalController::class, 'show']);
            Route::get('/{id}/download-soal', [BankSoalController::class, 'downloadSoal']);
            Route::get('/{id}/download-kunci', [BankSoalController::class, 'downloadKunci']);
            Route::delete('/{id}', [BankSoalController::class, 'destroy']);
        });

        // Library Digital for Guru (Read Only)
        Route::prefix('library')->group(function () {
            Route::get('/', [LibraryBookController::class, 'index']);
            Route::get('/categories', [LibraryBookController::class, 'categories']);
            Route::get('/{id}', [LibraryBookController::class, 'show']);
            Route::post('/{id}/increment-views', [LibraryBookController::class, 'incrementViews']);
            Route::post('/{id}/increment-downloads', [LibraryBookController::class, 'incrementDownloads']);
        });
    });

    Route::prefix('siswa')->group(function () {
        // Library Digital for Siswa (Read Only)
        Route::prefix('library')->group(function () {
            Route::get('/', [LibraryBookController::class, 'index']);
            Route::get('/categories', [LibraryBookController::class, 'categories']);
            Route::get('/{id}', [LibraryBookController::class, 'show']);
            Route::post('/{id}/increment-views', [LibraryBookController::class, 'incrementViews']);
            Route::post('/{id}/increment-downloads', [LibraryBookController::class, 'incrementDownloads']);
        });
    });

    Route::prefix('profile')->group(function () {
        Route::get('/', [ProfileController::class, 'getProfile']);
        Route::put('/', [ProfileController::class, 'updateProfile']);
        Route::post('/photo', [ProfileController::class, 'uploadPhoto']);
        Route::delete('/photo', [ProfileController::class, 'deletePhoto']);
        Route::post('/change-password', [ProfileController::class, 'changePassword']);
    });
});
