<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// ← TAMBAHKAN INI: Schedule Attendance Reminders
Schedule::command('attendance:send-reminder check_in')
    ->dailyAt('06:20') // 10 menit sebelum end_time_in (06:30)
    ->timezone('Asia/Jakarta')
    ->description('Send check-in reminder to guru');

Schedule::command('attendance:send-reminder check_out')
    ->dailyAt('13:40') // 10 menit sebelum normal_time_out (13:50)
    ->timezone('Asia/Jakarta')
    ->description('Send check-out reminder to guru');

// ← OPTIONAL: Reminder kedua 5 menit sebelum deadline
Schedule::command('attendance:send-reminder check_in')
    ->dailyAt('10:25') // 5 menit sebelum late_time_in (10:30)
    ->timezone('Asia/Jakarta')
    ->description('Send urgent check-in reminder to guru');
