-- MariaDB dump 10.19  Distrib 10.4.28-MariaDB, for osx10.10 (x86_64)
--
-- Host: localhost    Database: simmada
-- ------------------------------------------------------
-- Server version	9.3.0

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `attendance_settings`
--

DROP TABLE IF EXISTS `attendance_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attendance_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `start_time_in` time NOT NULL DEFAULT '05:00:00' COMMENT 'Awal waktu masuk',
  `end_time_in` time NOT NULL DEFAULT '06:30:00' COMMENT 'Batas waktu masuk tepat',
  `late_time_in` time NOT NULL DEFAULT '10:30:00' COMMENT 'Batas waktu masuk telat',
  `start_time_out` time NOT NULL DEFAULT '10:30:00' COMMENT 'Awal waktu pulang',
  `normal_time_out` time NOT NULL DEFAULT '13:50:00' COMMENT 'Waktu pulang normal',
  `end_time_out` time NOT NULL DEFAULT '16:00:00' COMMENT 'Batas waktu pulang',
  `location_lat` decimal(10,8) DEFAULT NULL COMMENT 'Latitude lokasi sekolah',
  `location_lng` decimal(11,8) DEFAULT NULL COMMENT 'Longitude lokasi sekolah',
  `max_radius` int NOT NULL DEFAULT '100' COMMENT 'Radius maksimal dalam meter',
  `require_photo` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Wajib foto saat presensi',
  `require_location` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Wajib share lokasi',
  `is_active` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Status aktif',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendance_settings`
--

LOCK TABLES `attendance_settings` WRITE;
/*!40000 ALTER TABLE `attendance_settings` DISABLE KEYS */;
INSERT INTO `attendance_settings` VALUES (1,'05:00:00','06:30:00','11:45:00','11:50:00','13:50:00','16:00:00',21.42247790,39.82370260,300,1,1,1,'2026-01-22 04:45:53','2026-01-24 06:02:42');
/*!40000 ALTER TABLE `attendance_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendances`
--

DROP TABLE IF EXISTS `attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attendances` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `guru_id` bigint unsigned NOT NULL,
  `date` date NOT NULL,
  `check_in_time` time DEFAULT NULL,
  `check_in_location_lat` decimal(10,8) DEFAULT NULL,
  `check_in_location_lng` decimal(11,8) DEFAULT NULL,
  `check_in_photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_in_status` enum('tepat_waktu','terlambat') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_out_time` time DEFAULT NULL,
  `check_out_location_lat` decimal(10,8) DEFAULT NULL,
  `check_out_location_lng` decimal(11,8) DEFAULT NULL,
  `check_out_photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_out_status` enum('normal','lebih_awal','lebih_lama') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('pending','approved','rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `verified_by` bigint unsigned DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendances_verified_by_foreign` (`verified_by`),
  KEY `attendances_guru_id_date_index` (`guru_id`,`date`),
  KEY `attendances_status_index` (`status`),
  KEY `attendances_date_index` (`date`),
  CONSTRAINT `attendances_guru_id_foreign` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`) ON DELETE CASCADE,
  CONSTRAINT `attendances_verified_by_foreign` FOREIGN KEY (`verified_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendances`
--

LOCK TABLES `attendances` WRITE;
/*!40000 ALTER TABLE `attendances` DISABLE KEYS */;
INSERT INTO `attendances` VALUES (1,24,'2026-01-24','11:41:11',-2.26459687,113.92308640,NULL,'terlambat','11:51:00',-2.26459348,113.92307281,NULL,'normal','approved',1,'2026-01-24 04:44:49',NULL,'2026-01-24 04:41:11','2026-01-24 04:51:00');
/*!40000 ALTER TABLE `attendances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_soal`
--

DROP TABLE IF EXISTS `bank_soal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_soal` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `guru_id` bigint unsigned NOT NULL,
  `mata_pelajaran_id` bigint unsigned NOT NULL,
  `judul` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `topik` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `kelas` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tingkat_kesulitan` enum('mudah','sedang','sulit') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sedang',
  `jumlah_pg` int NOT NULL DEFAULT '0',
  `jumlah_essay` int NOT NULL DEFAULT '0',
  `jumlah_isian` int NOT NULL DEFAULT '0',
  `jumlah_benar_salah` int NOT NULL DEFAULT '0',
  `file_soal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_kunci` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ai_prompt` text COLLATE utf8mb4_unicode_ci,
  `ai_response` longtext COLLATE utf8mb4_unicode_ci,
  `status` enum('draft','generated','downloaded') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'draft',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_soal_guru_id_created_at_index` (`guru_id`,`created_at`),
  KEY `bank_soal_mata_pelajaran_id_kelas_index` (`mata_pelajaran_id`,`kelas`),
  CONSTRAINT `bank_soal_guru_id_foreign` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bank_soal_mata_pelajaran_id_foreign` FOREIGN KEY (`mata_pelajaran_id`) REFERENCES `mata_pelajaran` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_soal`
--

LOCK TABLES `bank_soal` WRITE;
/*!40000 ALTER TABLE `bank_soal` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_soal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `counter_nis`
--

DROP TABLE IF EXISTS `counter_nis`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `counter_nis` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tahun` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nomor_terakhir` int NOT NULL DEFAULT '0',
  `prefix_sekolah` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '121262710001',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `counter_nis_tahun_unique` (`tahun`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `counter_nis`
--

LOCK TABLES `counter_nis` WRITE;
/*!40000 ALTER TABLE `counter_nis` DISABLE KEYS */;
INSERT INTO `counter_nis` VALUES (1,'2025',81,'121262710001','2026-01-21 22:53:05','2026-01-21 22:53:05'),(2,'2024',69,'121262710001','2026-01-21 22:53:05','2026-01-21 22:53:05'),(3,'2023',104,'121262710001','2026-01-21 22:53:05','2026-01-21 22:53:05');
/*!40000 ALTER TABLE `counter_nis` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dokumen_pendaftaran`
--

DROP TABLE IF EXISTS `dokumen_pendaftaran`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dokumen_pendaftaran` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pendaftaran_siswa_id` bigint unsigned NOT NULL,
  `jenis_dokumen` enum('foto','ijazah','kartu_keluarga','akta_kelahiran','bukti_pembayaran','surat_pernyataan','sertifikat_prestasi','surat_keterangan_tidak_mampu') COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ukuran_file` int NOT NULL COMMENT 'Size in bytes',
  `status_verifikasi` enum('pending','valid','tidak_valid') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `catatan_verifikasi` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dokumen_pendaftaran_pendaftaran_siswa_id_index` (`pendaftaran_siswa_id`),
  KEY `dokumen_pendaftaran_jenis_dokumen_index` (`jenis_dokumen`),
  KEY `dokumen_pendaftaran_status_verifikasi_index` (`status_verifikasi`),
  CONSTRAINT `dokumen_pendaftaran_pendaftaran_siswa_id_foreign` FOREIGN KEY (`pendaftaran_siswa_id`) REFERENCES `pendaftaran_siswa` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dokumen_pendaftaran`
--

LOCK TABLES `dokumen_pendaftaran` WRITE;
/*!40000 ALTER TABLE `dokumen_pendaftaran` DISABLE KEYS */;
/*!40000 ALTER TABLE `dokumen_pendaftaran` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guru`
--

DROP TABLE IF EXISTS `guru`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guru` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `nip` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nuptk` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jenis_kelamin` enum('L','P') COLLATE utf8mb4_unicode_ci NOT NULL,
  `tempat_lahir` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tanggal_lahir` date DEFAULT NULL,
  `alamat` text COLLATE utf8mb4_unicode_ci,
  `telepon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_kepegawaian` enum('PNS','PPPK','GTY','GTT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'GTT',
  `pendidikan_terakhir` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jurusan` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mata_pelajaran` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tanggal_masuk` date DEFAULT NULL,
  `status_aktif` enum('aktif','tidak_aktif','cuti') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'aktif',
  `catatan` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guru_nip_unique` (`nip`),
  KEY `guru_user_id_foreign` (`user_id`),
  CONSTRAINT `guru_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guru`
--

LOCK TABLES `guru` WRITE;
/*!40000 ALTER TABLE `guru` DISABLE KEYS */;
INSERT INTO `guru` VALUES (1,7,'1',NULL,'L',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:37','2026-01-21 22:53:37'),(2,8,'2',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:37','2026-01-21 22:53:37'),(3,9,'3',NULL,'P',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:37','2026-01-21 22:53:37'),(4,10,'4',NULL,'P',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:38','2026-01-21 22:53:38'),(5,11,'5',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:38','2026-01-21 22:53:38'),(6,12,'6',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:39','2026-01-21 22:53:39'),(7,13,'7',NULL,'P',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:39','2026-01-21 22:53:39'),(8,14,'8',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:39','2026-01-21 22:53:39'),(9,15,'9',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:40','2026-01-21 22:53:40'),(10,16,'10',NULL,'L',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:40','2026-01-21 22:53:40'),(11,17,'11',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:40','2026-01-21 22:53:40'),(12,18,'12',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:41','2026-01-21 22:53:41'),(13,19,'13',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:41','2026-01-21 22:53:41'),(14,20,'14',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:41','2026-01-21 22:53:41'),(15,21,'15',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:42','2026-01-21 22:53:42'),(16,22,'16',NULL,'P',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:42','2026-01-21 22:53:42'),(17,23,'17',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:42','2026-01-21 22:53:42'),(18,24,'18',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:43','2026-01-21 22:53:43'),(19,25,'19',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:43','2026-01-21 22:53:43'),(20,26,'20',NULL,'P',NULL,NULL,NULL,NULL,'PNS',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:43','2026-01-21 22:53:43'),(21,27,'21',NULL,'P',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:44','2026-01-21 22:53:44'),(22,28,'22',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:44','2026-01-21 22:53:44'),(23,29,'23',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:44','2026-01-21 22:53:44'),(24,30,'24',NULL,'L',NULL,NULL,NULL,NULL,'GTY',NULL,NULL,NULL,NULL,'aktif',NULL,'2026-01-21 22:53:45','2026-01-21 22:53:45');
/*!40000 ALTER TABLE `guru` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `guru_mengajar`
--

DROP TABLE IF EXISTS `guru_mengajar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guru_mengajar` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `guru_id` bigint unsigned NOT NULL,
  `mata_pelajaran_id` bigint unsigned NOT NULL,
  `kelas_id` bigint unsigned NOT NULL,
  `tahun_ajaran` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_guru_mapel_kelas` (`guru_id`,`mata_pelajaran_id`,`kelas_id`,`tahun_ajaran`),
  KEY `guru_mengajar_guru_id_tahun_ajaran_index` (`guru_id`,`tahun_ajaran`),
  KEY `guru_mengajar_mata_pelajaran_id_tahun_ajaran_index` (`mata_pelajaran_id`,`tahun_ajaran`),
  KEY `guru_mengajar_kelas_id_tahun_ajaran_index` (`kelas_id`,`tahun_ajaran`),
  CONSTRAINT `guru_mengajar_guru_id_foreign` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`) ON DELETE CASCADE,
  CONSTRAINT `guru_mengajar_kelas_id_foreign` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `guru_mengajar_mata_pelajaran_id_foreign` FOREIGN KEY (`mata_pelajaran_id`) REFERENCES `mata_pelajaran` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guru_mengajar`
--

LOCK TABLES `guru_mengajar` WRITE;
/*!40000 ALTER TABLE `guru_mengajar` DISABLE KEYS */;
INSERT INTO `guru_mengajar` VALUES (2,24,1,1,'2026/2027','2026-01-22 10:14:06','2026-01-22 10:14:06');
/*!40000 ALTER TABLE `guru_mengajar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jadwal_mengajar`
--

DROP TABLE IF EXISTS `jadwal_mengajar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jadwal_mengajar` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `guru_mengajar_id` bigint unsigned NOT NULL,
  `pengaturan_jam_id` bigint unsigned NOT NULL,
  `tahun_ajaran` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `keterangan` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_jadwal_guru_jam_ta` (`guru_mengajar_id`,`pengaturan_jam_id`,`tahun_ajaran`),
  KEY `idx_jadwal_jam_ta` (`pengaturan_jam_id`,`tahun_ajaran`),
  CONSTRAINT `jadwal_mengajar_guru_mengajar_id_foreign` FOREIGN KEY (`guru_mengajar_id`) REFERENCES `guru_mengajar` (`id`) ON DELETE CASCADE,
  CONSTRAINT `jadwal_mengajar_pengaturan_jam_id_foreign` FOREIGN KEY (`pengaturan_jam_id`) REFERENCES `pengaturan_jam` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jadwal_mengajar`
--

LOCK TABLES `jadwal_mengajar` WRITE;
/*!40000 ALTER TABLE `jadwal_mengajar` DISABLE KEYS */;
INSERT INTO `jadwal_mengajar` VALUES (1,2,3,'2026/2027',NULL,'2026-01-23 04:46:55','2026-01-23 04:46:55'),(2,2,4,'2026/2027',NULL,'2026-01-23 04:46:55','2026-01-23 04:46:55');
/*!40000 ALTER TABLE `jadwal_mengajar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jalur_pendaftaran`
--

DROP TABLE IF EXISTS `jalur_pendaftaran`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jalur_pendaftaran` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nama_jalur` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `kode_jalur` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `kuota` int NOT NULL DEFAULT '0',
  `keterangan` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `jalur_pendaftaran_kode_jalur_unique` (`kode_jalur`),
  KEY `jalur_pendaftaran_is_active_index` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jalur_pendaftaran`
--

LOCK TABLES `jalur_pendaftaran` WRITE;
/*!40000 ALTER TABLE `jalur_pendaftaran` DISABLE KEYS */;
INSERT INTO `jalur_pendaftaran` VALUES (1,'Reguler','REG',100,'Jalur pendaftaran reguler untuk calon siswa umum',1,'2026-01-24 12:36:10','2026-01-24 12:36:10'),(2,'Prestasi','PRES',20,'Jalur pendaftaran untuk calon siswa berprestasi (akademik/non-akademik)',1,'2026-01-24 12:36:10','2026-01-24 12:36:10');
/*!40000 ALTER TABLE `jalur_pendaftaran` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kelas`
--

DROP TABLE IF EXISTS `kelas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kelas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nama_kelas` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tingkat` enum('7','8','9') COLLATE utf8mb4_unicode_ci NOT NULL,
  `wali_kelas_id` bigint unsigned DEFAULT NULL,
  `kapasitas` int NOT NULL DEFAULT '30',
  `tahun_ajaran` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `kelas_wali_kelas_id_foreign` (`wali_kelas_id`),
  CONSTRAINT `kelas_wali_kelas_id_foreign` FOREIGN KEY (`wali_kelas_id`) REFERENCES `guru` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kelas`
--

LOCK TABLES `kelas` WRITE;
/*!40000 ALTER TABLE `kelas` DISABLE KEYS */;
INSERT INTO `kelas` VALUES (1,'7A','7',9,30,'2025/2026',1,'2026-01-21 22:53:05','2026-01-24 14:20:32'),(2,'7B','7',3,30,'2025/2026',1,'2026-01-21 22:53:05','2026-01-24 14:21:04'),(3,'7C','7',NULL,30,'2024/2025',1,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(4,'8A','8',NULL,30,'2024/2025',1,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(5,'8B','8',NULL,30,'2024/2025',1,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(6,'8C','8',NULL,30,'2024/2025',1,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(7,'9A','9',NULL,30,'2024/2025',1,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(8,'9B','9',NULL,30,'2024/2025',1,'2026-01-21 22:53:06','2026-01-21 22:53:06'),(9,'9C','9',NULL,30,'2024/2025',1,'2026-01-21 22:53:06','2026-01-21 22:53:06');
/*!40000 ALTER TABLE `kelas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `library_books`
--

DROP TABLE IF EXISTS `library_books`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `library_books` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publisher` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publication_year` year DEFAULT NULL,
  `isbn` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `pages` int DEFAULT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Indonesia',
  `file_type` enum('upload','link') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'upload',
  `file_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_url` text COLLATE utf8mb4_unicode_ci,
  `file_size` bigint DEFAULT NULL COMMENT 'Size in bytes',
  `cover_type` enum('upload','link') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'upload',
  `cover_path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_url` text COLLATE utf8mb4_unicode_ci,
  `views_count` int NOT NULL DEFAULT '0',
  `downloads_count` int NOT NULL DEFAULT '0',
  `status` enum('available','maintenance','unavailable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `library_books_created_by_foreign` (`created_by`),
  KEY `library_books_updated_by_foreign` (`updated_by`),
  KEY `library_books_category_index` (`category`),
  KEY `library_books_status_index` (`status`),
  KEY `library_books_publication_year_index` (`publication_year`),
  FULLTEXT KEY `library_books_title_author_description_fulltext` (`title`,`author`,`description`),
  CONSTRAINT `library_books_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `library_books_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `library_books`
--

LOCK TABLES `library_books` WRITE;
/*!40000 ALTER TABLE `library_books` DISABLE KEYS */;
INSERT INTO `library_books` VALUES (1,'Al-Quran dan Terjemahannya','Kementerian Agama RI','Kemenag RI',2023,'978-602-1234-56-7','Agama Islam','Al-Quran lengkap dengan terjemahan bahasa Indonesia',604,'Indonesia','link',NULL,'https://dn720207.ca.archive.org/0/items/Quran-Kareem-Khawagah-The-Blue-Page-Quran/Quran-Kareem-Khawagah-The-Blue-Page-Quran.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1609599006353-e629aaabfeae?w=800',490,51,'available',1,1,1,'2026-01-23 10:45:28','2026-01-23 11:49:02'),(3,'Matematika Dasar SMP','Dr. Ahmad Fauzi','Erlangga',2024,'978-602-1234-58-9','Akademik','Buku matematika untuk siswa SMP kelas 7-9',320,'Indonesia','link',NULL,'https://example.com/matematika-smp.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1596495577886-d920f1fb7238?w=800',235,53,'available',0,1,1,'2026-01-23 10:45:28','2026-01-23 10:45:28'),(4,'Bahasa Indonesia untuk SMP','Prof. Siti Nurhaliza','Gramedia',2024,'978-602-1234-59-0','Akademik','Panduan lengkap bahasa Indonesia tingkat SMP',280,'Indonesia','link',NULL,'https://example.com/bahasa-indonesia.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1456513080510-7bf3a84b82f8?w=800',480,40,'available',0,1,1,'2026-01-23 10:45:28','2026-01-23 11:45:15'),(5,'Sejarah Islam di Indonesia','Dr. Muhammad Yusuf','Mizan',2023,'978-602-1234-60-6','Sejarah','Perjalanan Islam di Nusantara dari masa ke masa',450,'Indonesia','link',NULL,'https://example.com/sejarah-islam.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1524995997946-a1c2e315a42f?w=800',495,122,'available',1,1,1,'2026-01-23 10:45:28','2026-01-23 10:45:28'),(6,'Ensiklopedia Sains','Tim Penulis Sains','Erlangga',2024,'978-602-1234-61-7','Sains & Teknologi','Ensiklopedia lengkap tentang dunia sains',600,'Indonesia','link',NULL,'https://example.com/ensiklopedia-sains.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1507842217343-583bb7270b66?w=800',202,7,'available',0,1,1,'2026-01-23 10:45:28','2026-01-23 11:45:25'),(7,'Laskar Pelangi','Andrea Hirata','Bentang Pustaka',2005,'978-979-1227-78-0','Fiksi','Novel inspiratif tentang perjuangan anak-anak di Belitung',529,'Indonesia','link',NULL,'https://example.com/laskar-pelangi.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1544947950-fa07a98d237f?w=800',430,199,'available',1,1,1,'2026-01-23 10:45:28','2026-01-23 10:45:28'),(8,'Akhlak Mulia dalam Islam','Ustadz Abdul Somad','Pustaka Al-Kautsar',2023,'978-602-1234-62-8','Agama Islam','Panduan membangun akhlak mulia berdasarkan ajaran Islam',250,'Indonesia','link',NULL,'https://example.com/akhlak-mulia.pdf',NULL,'link',NULL,'https://images.unsplash.com/photo-1512820790803-83ca734da794?w=800',488,50,'available',0,1,1,'2026-01-23 10:45:28','2026-01-23 10:45:28'),(9,'Wiro Sableng : Empat Berewok Dari Goa Sanggreng','Bastian Tito','-',1990,NULL,'Fiksi','Ebook Wiro Sableng',150,'Indonesia','link',NULL,'https://drive.google.com/file/d/1Cg9sFVKlAsPiP8xYMVu3CUny74t9TUnx/view',NULL,'link',NULL,'https://upload.wikimedia.org/wikipedia/id/0/09/Novempatberewokdarigoasanggreng.jpeg',4,1,'available',0,1,1,'2026-01-23 11:52:10','2026-01-24 17:41:36');
/*!40000 ALTER TABLE `library_books` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mata_pelajaran`
--

DROP TABLE IF EXISTS `mata_pelajaran`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mata_pelajaran` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `kode_mapel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_mapel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `jtm` int NOT NULL,
  `kkm` decimal(5,2) NOT NULL,
  `tingkat` enum('MI','MTs','MA') COLLATE utf8mb4_unicode_ci NOT NULL,
  `kelompok` enum('wajib','pilihan') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'wajib',
  `tahun_ajaran` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mata_pelajaran_kode_mapel_unique` (`kode_mapel`),
  KEY `mata_pelajaran_tingkat_tahun_ajaran_index` (`tingkat`,`tahun_ajaran`),
  KEY `mata_pelajaran_is_active_tahun_ajaran_index` (`is_active`,`tahun_ajaran`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mata_pelajaran`
--

LOCK TABLES `mata_pelajaran` WRITE;
/*!40000 ALTER TABLE `mata_pelajaran` DISABLE KEYS */;
INSERT INTO `mata_pelajaran` VALUES (1,'FKH','Fikih',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(2,'AA','Aqidah Akhlak',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(3,'SKI','Sejara Kebudayaan islam',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(4,'BARB','Bahasa Arab',3,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(5,'PP','Pendidikan Pancasila',3,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(6,'BIND','Bahasa Indonesia',5,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(7,'MTK','Matematika',4,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(8,'IPA','Ilmu Pengetahuan Alam',4,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(9,'IPS','Ilmu pengetahuan Sosial',3,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(10,'BING','Bahasa Inggris',3,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(11,'PJOK','Pendidkan Jasmani Olahraga Kesehatan',3,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(12,'INF','Informatika/TIK',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(13,'SBK','Seni Budaya/Prakarya',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(14,'THF','Tahfidz',1,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(15,'NHW','Nahwu Shorof',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(16,'ADY','Ad\'iyah',1,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(17,'RSF','Risalah Fiqih',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(18,'HDS','Hadits',2,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34'),(19,'TH','Tauhid',1,75.00,'MTs','wajib','2026/2027',1,'2026-01-21 22:54:34','2026-01-21 22:54:34');
/*!40000 ALTER TABLE `mata_pelajaran` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000000_create_users_table',1),(2,'0001_01_01_000001_create_cache_table',1),(3,'0001_01_01_000002_create_jobs_table',1),(4,'2026_01_20_122807_create_personal_access_tokens_table',1),(5,'2026_01_21_035439_create_guru_table',1),(6,'2026_01_21_045556_create_kelas_table',1),(7,'2026_01_21_045557_create_counter_nis_table',1),(8,'2026_01_21_045557_create_siswa_table',1),(9,'2026_01_22_042056_create_mata_pelajaran_table',1),(10,'2026_01_22_042124_create_pengaturan_jam_table',1),(11,'2026_01_22_042143_create_guru_mengajar_table',1),(12,'2026_01_22_042210_create_jadwal_mengajar_table',1),(13,'2026_01_22_113821_create_attendance_settings_table',2),(14,'2026_01_22_113858_create_attendances_table',2),(15,'2026_01_22_160706_create_modul_ajar_table',3),(16,'2026_01_22_162653_create_bank_soal_table',4),(17,'2026_01_23_174109_create_library_books_table',5),(18,'2026_01_24_131840_create_news_table',6),(19,'2026_01_24_191819_create_periode_spmb_table',7),(20,'2026_01_24_191849_create_jalur_pendaftaran_table',7),(21,'2026_01_24_191917_create_pendaftaran_siswa_table',7),(22,'2026_01_24_191941_create_dokumen_pendaftaran_table',7),(23,'2026_01_24_192003_create_pengaturan_spmb_table',7);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `modul_ajar`
--

DROP TABLE IF EXISTS `modul_ajar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `modul_ajar` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `guru_id` bigint unsigned NOT NULL,
  `mata_pelajaran_id` bigint unsigned NOT NULL,
  `kelas` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fase` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `judul` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `topik` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `jumlah_pertemuan` int NOT NULL DEFAULT '1',
  `alokasi_waktu` int NOT NULL,
  `jumlah_siswa` int NOT NULL DEFAULT '30',
  `kurikulum` enum('kurmer','berbasis_cinta') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'kurmer',
  `capaian_pembelajaran` text COLLATE utf8mb4_unicode_ci,
  `tujuan_pembelajaran` text COLLATE utf8mb4_unicode_ci,
  `profil_pelajar_pancasila` text COLLATE utf8mb4_unicode_ci,
  `model_pembelajaran` text COLLATE utf8mb4_unicode_ci,
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ai_prompt` text COLLATE utf8mb4_unicode_ci,
  `ai_response` longtext COLLATE utf8mb4_unicode_ci,
  `status` enum('draft','generated','downloaded') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'draft',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `modul_ajar_guru_id_created_at_index` (`guru_id`,`created_at`),
  KEY `modul_ajar_mata_pelajaran_id_kelas_index` (`mata_pelajaran_id`,`kelas`),
  CONSTRAINT `modul_ajar_guru_id_foreign` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`) ON DELETE CASCADE,
  CONSTRAINT `modul_ajar_mata_pelajaran_id_foreign` FOREIGN KEY (`mata_pelajaran_id`) REFERENCES `mata_pelajaran` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `modul_ajar`
--

LOCK TABLES `modul_ajar` WRITE;
/*!40000 ALTER TABLE `modul_ajar` DISABLE KEYS */;
/*!40000 ALTER TABLE `modul_ajar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `news`
--

DROP TABLE IF EXISTS `news`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `news` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` enum('akademik','prestasi','kegiatan','pengumuman','umum') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'umum',
  `tags` json DEFAULT NULL,
  `status` enum('draft','published','archived') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'draft',
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_headline` tinyint(1) NOT NULL DEFAULT '0',
  `views_count` int NOT NULL DEFAULT '0',
  `published_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `news_slug_unique` (`slug`),
  KEY `news_user_id_foreign` (`user_id`),
  KEY `news_slug_index` (`slug`),
  KEY `news_category_index` (`category`),
  KEY `news_status_index` (`status`),
  KEY `news_is_featured_index` (`is_featured`),
  KEY `news_is_headline_index` (`is_headline`),
  KEY `news_published_at_index` (`published_at`),
  CONSTRAINT `news_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `news`
--

LOCK TABLES `news` WRITE;
/*!40000 ALTER TABLE `news` DISABLE KEYS */;
INSERT INTO `news` VALUES (1,1,'Siswa MTs Darul Ulum Palangka Raya Gelar Kegiatan Pramuka, Tingkatkan Karakter dan Keterampilan','siswa-mts-darul-ulum-palangka-raya-gelar-kegiatan-pramuka-tingkatkan-karakter-dan-keterampilan','Madrasah Tsanawiyah (MTs) Darul Ulum Palangka Raya mengadakan kegiatan kepramukaan untuk siswa-siswinya. Kegiatan ini bertujuan membentuk karakter siswa yang mandiri, disiplin, dan bertanggung jawab sekaligus melatih keterampilan kepemimpinan dan kerja sama tim melalui berbagai aktivitas outdoor dan indoor yang mendidik.','<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Palangka Raya - MTs Darul Ulum Palangka Raya kembali menggelar kegiatan rutin kepramukaan yang diikuti oleh seluruh siswa. Kegiatan ini merupakan bagian dari program ekstrakurikuler wajib yang bertujuan membentuk karakter siswa yang berakhlak mulia, mandiri, dan memiliki jiwa kepemimpinan.</p>\r\n<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Kegiatan pramuka kali ini dipenuhi dengan berbagai aktivitas menarik yang menguji keterampilan dan mental siswa. Para peserta mengikuti serangkaian kegiatan mulai dari Peraturan Baris-Berbaris (PBB), pembelajaran simpul tali-temali, pendirian tenda, hingga permainan outbound yang mengasah kemampuan problem solving dan kerja sama tim.</p>\r\n<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Kepala MTs Darul Ulum Palangka Raya menyampaikan bahwa kegiatan pramuka sangat penting dalam mendukung pendidikan karakter siswa. \"Melalui pramuka, kami tidak hanya mengajarkan keterampilan teknis, tetapi juga menanamkan nilai-nilai luhur seperti kejujuran, kedisiplinan, kepedulian terhadap sesama, dan cinta tanah air,\" ujarnya.</p>\r\n<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Para Pembina Pramuka dari madrasah membimbing siswa dengan penuh semangat. Mereka mengajarkan berbagai materi kepramukaan sesuai dengan tingkatan siaga, penggalang, dan penegak. Siswa juga dilatih untuk mandiri dalam menghadapi tantangan serta belajar bertanggung jawab atas tugas yang diberikan.</p>\r\n<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Salah seorang siswa kelas VIII mengaku sangat antusias mengikuti kegiatan ini. \"Saya senang sekali bisa belajar banyak hal baru seperti membuat tandu darurat dan teknik komunikasi sandi. Kami juga belajar bekerja sama dengan teman-teman dalam kelompok,\" ungkapnya.</p>\r\n<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Kegiatan pramuka di MTs Darul Ulum tidak hanya fokus pada aktivitas fisik, tetapi juga mengintegrasikan nilai-nilai keislaman dalam setiap kegiatannya. Siswa diajak untuk selalu mengingat Allah dalam setiap aktivitas dan menjadikan ajaran Islam sebagai pedoman dalam bersikap dan berperilaku.</p>\r\n<p class=\"font-claude-response-body break-words whitespace-normal leading-[1.7]\" style=\"text-align: justify;\">Ke depannya, MTs Darul Ulum Palangka Raya berencana untuk terus mengembangkan program kepramukaan dengan mengikutsertakan siswa dalam berbagai perlombaan dan jambore tingkat kota hingga provinsi, sehingga siswa dapat mengharumkan nama madrasah sekaligus mengembangkan potensi diri mereka.</p>','uploads/news/1769238618_ujf7ZgfaVS.jpeg','kegiatan','[\"#Pramuka #MTsDarulUlum #PalangkaRaya #\"]','published',1,1,42,'2026-01-24 07:10:18','2026-01-24 07:10:18','2026-01-24 10:36:39');
/*!40000 ALTER TABLE `news` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pendaftaran_siswa`
--

DROP TABLE IF EXISTS `pendaftaran_siswa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pendaftaran_siswa` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `periode_spmb_id` bigint unsigned NOT NULL,
  `jalur_pendaftaran_id` bigint unsigned NOT NULL,
  `nomor_pendaftaran` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tanggal_daftar` date NOT NULL,
  `nama_lengkap` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nik` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nisn` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jenis_kelamin` enum('L','P') COLLATE utf8mb4_unicode_ci NOT NULL,
  `tempat_lahir` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tanggal_lahir` date DEFAULT NULL,
  `agama` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `anak_ke` int DEFAULT NULL,
  `jumlah_saudara` int DEFAULT NULL,
  `alamat` text COLLATE utf8mb4_unicode_ci,
  `rt` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rw` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kelurahan` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kecamatan` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kabupaten` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provinsi` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kode_pos` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telepon` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nama_ayah` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nik_ayah` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pekerjaan_ayah` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `penghasilan_ayah` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telepon_ayah` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nama_ibu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nik_ibu` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pekerjaan_ibu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `penghasilan_ibu` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telepon_ibu` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nama_wali` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nik_wali` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pekerjaan_wali` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `penghasilan_wali` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telepon_wali` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hubungan_wali` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asal_sekolah` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `npsn_sekolah` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alamat_sekolah` text COLLATE utf8mb4_unicode_ci,
  `tahun_lulus` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_pendaftaran` enum('baru','verifikasi_berkas','verifikasi_pembayaran','diterima','ditolak') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'baru',
  `catatan_verifikasi` text COLLATE utf8mb4_unicode_ci,
  `verified_by` bigint unsigned DEFAULT NULL,
  `verified_at` timestamp NULL DEFAULT NULL,
  `is_converted_to_siswa` tinyint(1) NOT NULL DEFAULT '0',
  `siswa_id` bigint unsigned DEFAULT NULL,
  `converted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pendaftaran_siswa_nomor_pendaftaran_unique` (`nomor_pendaftaran`),
  KEY `pendaftaran_siswa_jalur_pendaftaran_id_foreign` (`jalur_pendaftaran_id`),
  KEY `pendaftaran_siswa_verified_by_foreign` (`verified_by`),
  KEY `pendaftaran_siswa_siswa_id_foreign` (`siswa_id`),
  KEY `pendaftaran_siswa_nomor_pendaftaran_index` (`nomor_pendaftaran`),
  KEY `pendaftaran_siswa_status_pendaftaran_index` (`status_pendaftaran`),
  KEY `pendaftaran_siswa_email_index` (`email`),
  KEY `pendaftaran_siswa_tanggal_daftar_index` (`tanggal_daftar`),
  KEY `pendaftaran_siswa_periode_spmb_id_jalur_pendaftaran_id_index` (`periode_spmb_id`,`jalur_pendaftaran_id`),
  CONSTRAINT `pendaftaran_siswa_jalur_pendaftaran_id_foreign` FOREIGN KEY (`jalur_pendaftaran_id`) REFERENCES `jalur_pendaftaran` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pendaftaran_siswa_periode_spmb_id_foreign` FOREIGN KEY (`periode_spmb_id`) REFERENCES `periode_spmb` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pendaftaran_siswa_siswa_id_foreign` FOREIGN KEY (`siswa_id`) REFERENCES `siswa` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pendaftaran_siswa_verified_by_foreign` FOREIGN KEY (`verified_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pendaftaran_siswa`
--

LOCK TABLES `pendaftaran_siswa` WRITE;
/*!40000 ALTER TABLE `pendaftaran_siswa` DISABLE KEYS */;
/*!40000 ALTER TABLE `pendaftaran_siswa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pengaturan_jam`
--

DROP TABLE IF EXISTS `pengaturan_jam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pengaturan_jam` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hari` enum('Senin','Selasa','Rabu','Kamis','Jumat','Sabtu') COLLATE utf8mb4_unicode_ci NOT NULL,
  `jam_ke` int NOT NULL,
  `jam_mulai` time NOT NULL,
  `jam_selesai` time NOT NULL,
  `durasi` int NOT NULL,
  `jenis_kegiatan` enum('belajar','upacara','istirahat','kegiatan_pagi','muhadhoroh') COLLATE utf8mb4_unicode_ci NOT NULL,
  `tahun_ajaran` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pengaturan_jam_hari_jam_ke_tahun_ajaran_unique` (`hari`,`jam_ke`,`tahun_ajaran`),
  KEY `pengaturan_jam_hari_jenis_kegiatan_tahun_ajaran_index` (`hari`,`jenis_kegiatan`,`tahun_ajaran`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pengaturan_jam`
--

LOCK TABLES `pengaturan_jam` WRITE;
/*!40000 ALTER TABLE `pengaturan_jam` DISABLE KEYS */;
INSERT INTO `pengaturan_jam` VALUES (1,'Senin',1,'06:30:00','07:10:00',40,'upacara','2026/2027','2026-01-21 22:57:54','2026-01-21 22:59:01'),(2,'Senin',2,'07:10:00','07:50:00',40,'kegiatan_pagi','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(3,'Senin',3,'07:50:00','08:30:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(4,'Senin',4,'08:30:00','09:10:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(5,'Senin',5,'09:10:00','09:30:00',20,'istirahat','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(6,'Senin',6,'09:30:00','10:10:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(7,'Senin',7,'10:10:00','10:50:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(8,'Senin',8,'10:50:00','11:30:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(9,'Senin',9,'11:30:00','12:05:00',35,'istirahat','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(10,'Senin',10,'12:05:00','12:45:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(11,'Senin',11,'12:45:00','13:25:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(12,'Senin',12,'13:25:00','14:05:00',40,'belajar','2026/2027','2026-01-21 22:57:54','2026-01-21 22:57:54'),(13,'Selasa',1,'06:30:00','07:10:00',40,'kegiatan_pagi','2026/2027','2026-01-22 00:39:29','2026-01-22 00:40:57'),(14,'Selasa',2,'07:10:00','07:50:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(15,'Selasa',3,'07:50:00','08:30:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(16,'Selasa',4,'08:30:00','09:10:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(17,'Selasa',5,'09:10:00','09:30:00',20,'istirahat','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(18,'Selasa',6,'09:30:00','10:10:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(19,'Selasa',7,'10:10:00','10:50:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(20,'Selasa',8,'10:50:00','11:30:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(21,'Selasa',9,'11:30:00','11:50:00',20,'istirahat','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(22,'Selasa',10,'11:50:00','12:30:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(23,'Selasa',11,'12:30:00','13:10:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(24,'Selasa',12,'13:10:00','13:50:00',40,'belajar','2026/2027','2026-01-22 00:39:29','2026-01-22 00:39:29'),(25,'Rabu',1,'06:30:00','07:10:00',40,'kegiatan_pagi','2026/2027','2026-01-22 00:41:54','2026-01-22 00:42:30'),(26,'Rabu',2,'07:10:00','07:50:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(27,'Rabu',3,'07:50:00','08:30:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(28,'Rabu',4,'08:30:00','09:10:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(29,'Rabu',5,'09:10:00','09:30:00',20,'istirahat','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(30,'Rabu',6,'09:30:00','10:10:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(31,'Rabu',7,'10:10:00','10:50:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(32,'Rabu',8,'10:50:00','11:30:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(33,'Rabu',9,'11:30:00','11:50:00',20,'istirahat','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(34,'Rabu',10,'11:50:00','12:30:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(35,'Rabu',11,'12:30:00','13:10:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(36,'Rabu',12,'13:10:00','13:50:00',40,'belajar','2026/2027','2026-01-22 00:41:54','2026-01-22 00:41:54'),(37,'Kamis',1,'06:30:00','07:10:00',40,'kegiatan_pagi','2026/2027','2026-01-22 00:43:24','2026-01-22 00:44:05'),(38,'Kamis',2,'07:10:00','07:50:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(39,'Kamis',3,'07:50:00','08:30:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(40,'Kamis',4,'08:30:00','09:10:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(41,'Kamis',5,'09:10:00','09:30:00',20,'istirahat','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(42,'Kamis',6,'09:30:00','10:10:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(43,'Kamis',7,'10:10:00','10:50:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(44,'Kamis',8,'10:50:00','11:30:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(45,'Kamis',9,'11:30:00','11:50:00',20,'istirahat','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(46,'Kamis',10,'11:50:00','12:30:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(47,'Kamis',11,'12:30:00','13:10:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(48,'Kamis',12,'13:10:00','13:50:00',40,'belajar','2026/2027','2026-01-22 00:43:24','2026-01-22 00:43:24'),(49,'Jumat',1,'06:30:00','07:10:00',40,'kegiatan_pagi','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:36'),(50,'Jumat',2,'06:50:00','07:30:00',40,'belajar','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:23'),(51,'Jumat',3,'07:30:00','08:10:00',40,'belajar','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:23'),(52,'Jumat',4,'08:10:00','08:50:00',40,'belajar','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:23'),(53,'Jumat',5,'08:50:00','09:10:00',20,'istirahat','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:23'),(54,'Jumat',6,'09:10:00','09:50:00',40,'belajar','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:23'),(55,'Jumat',7,'09:50:00','10:30:00',40,'belajar','2026/2027','2026-01-22 00:45:23','2026-01-22 00:45:23'),(56,'Sabtu',1,'06:30:00','07:10:00',40,'muhadhoroh','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:42'),(57,'Sabtu',2,'06:50:00','07:30:00',40,'belajar','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(58,'Sabtu',3,'07:30:00','08:10:00',40,'belajar','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(59,'Sabtu',4,'08:10:00','08:50:00',40,'belajar','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(60,'Sabtu',5,'08:50:00','09:10:00',20,'istirahat','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(61,'Sabtu',6,'09:10:00','09:50:00',40,'belajar','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(62,'Sabtu',7,'09:50:00','10:30:00',40,'belajar','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(63,'Sabtu',8,'10:30:00','11:10:00',40,'belajar','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(64,'Sabtu',9,'11:10:00','11:30:00',20,'istirahat','2026/2027','2026-01-22 00:46:21','2026-01-22 00:46:21'),(65,'Sabtu',10,'11:30:00','12:10:00',40,'belajar','2026/2027','2026-01-22 00:46:22','2026-01-22 00:46:22'),(66,'Sabtu',11,'12:10:00','12:50:00',40,'belajar','2026/2027','2026-01-22 00:46:22','2026-01-22 00:46:22'),(67,'Sabtu',12,'12:50:00','13:30:00',40,'belajar','2026/2027','2026-01-22 00:46:22','2026-01-22 00:46:22');
/*!40000 ALTER TABLE `pengaturan_jam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pengaturan_spmb`
--

DROP TABLE IF EXISTS `pengaturan_spmb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pengaturan_spmb` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `type` enum('text','number','json','image') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pengaturan_spmb_key_unique` (`key`),
  KEY `pengaturan_spmb_key_index` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pengaturan_spmb`
--

LOCK TABLES `pengaturan_spmb` WRITE;
/*!40000 ALTER TABLE `pengaturan_spmb` DISABLE KEYS */;
INSERT INTO `pengaturan_spmb` VALUES (1,'syarat_ketentuan','1. Berusia maksimal 15 tahun pada 1 Juli 2025\n2. Lulus SD/MI atau sederajat\n3. Memiliki ijazah atau surat keterangan lulus\n4. Sehat jasmani dan rohani\n5. Tidak buta warna (untuk jurusan tertentu)','text','Syarat dan ketentuan pendaftaran SPMB','2026-01-24 12:36:11','2026-01-24 12:36:11'),(2,'informasi_pembayaran','Biaya pendaftaran: Rp 250.000,-\n\nMetode Pembayaran:\n- Transfer Bank\n- Tunai ke Bendahara\n\nSetelah pembayaran, upload bukti transfer pada form pendaftaran.','text','Informasi biaya dan cara pembayaran','2026-01-24 12:36:11','2026-01-24 12:36:11'),(3,'rekening_bank','[{\"bank\":\"BRI\",\"nomor_rekening\":\"1234567890\",\"atas_nama\":\"BENDAHARA MADRASAH\"}]','json','Daftar rekening bank untuk pembayaran','2026-01-24 12:36:11','2026-01-24 17:28:29'),(4,'contact_person','[{\"nama\":\"Ibu Siti\",\"jabatan\":\"Staff TU\",\"telepon\":\"081234567890\"}]','json','Contact person untuk informasi SPMB','2026-01-24 12:36:11','2026-01-24 17:28:29'),(5,'alur_pendaftaran','1. Isi formulir pendaftaran online\n2. Upload dokumen persyaratan\n3. Lakukan pembayaran\n4. Upload bukti pembayaran\n5. Tunggu verifikasi dari admin\n6. Cek status pendaftaran secara berkala','text','Alur proses pendaftaran SPMB','2026-01-24 12:36:11','2026-01-24 12:36:11'),(6,'banner_image',NULL,'image','Banner image untuk halaman SPMB','2026-01-24 12:36:11','2026-01-24 12:36:11'),(7,'waktu_operasional','Senin - Jumat: 08.00 - 15.00 WIB\nSabtu: 08.00 - 12.00 WIB\nMinggu & Libur: Tutup','text','Waktu operasional pelayanan SPMB','2026-01-24 12:36:11','2026-01-24 12:36:11'),(8,'lokasi_pendaftaran','Madrasah Tsanawiyah Darul Ulum Palangka Raya\nJl. Dr. Murjani, Gang Sari 45\nKota Palangka Raya, Provinsi kalimantan tengah','text','Alamat lokasi pendaftaran offline','2026-01-24 12:36:11','2026-01-24 17:28:29');
/*!40000 ALTER TABLE `pengaturan_spmb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `periode_spmb`
--

DROP TABLE IF EXISTS `periode_spmb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `periode_spmb` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tahun_ajaran` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gelombang` int NOT NULL DEFAULT '1',
  `tanggal_mulai` date NOT NULL,
  `tanggal_selesai` date NOT NULL,
  `biaya_pendaftaran` decimal(15,2) NOT NULL DEFAULT '0.00',
  `kuota_total` int NOT NULL DEFAULT '0',
  `status` enum('aktif','tidak_aktif') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'tidak_aktif',
  `keterangan` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `periode_spmb_status_index` (`status`),
  KEY `periode_spmb_tahun_ajaran_gelombang_index` (`tahun_ajaran`,`gelombang`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `periode_spmb`
--

LOCK TABLES `periode_spmb` WRITE;
/*!40000 ALTER TABLE `periode_spmb` DISABLE KEYS */;
INSERT INTO `periode_spmb` VALUES (1,'2025/2026',1,'2026-01-01','2026-03-31',250000.00,120,'aktif','Gelombang 1 Tahun Ajaran 2025/2026','2026-01-24 12:36:10','2026-01-24 17:26:34'),(2,'2025/2026',2,'2025-04-01','2025-06-30',250000.00,80,'tidak_aktif','Gelombang 2 Tahun Ajaran 2025/2026','2026-01-24 12:36:10','2026-01-24 12:36:10');
/*!40000 ALTER TABLE `periode_spmb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_expires_at_index` (`expires_at`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
INSERT INTO `personal_access_tokens` VALUES (1,'App\\Models\\User',1,'auth-token','d3064bf56a6f78d5cfe02f825833ae3908633a79dff99847a9684c32a068420d','[\"*\"]','2026-01-22 01:04:45',NULL,'2026-01-21 22:53:21','2026-01-22 01:04:45'),(2,'App\\Models\\User',1,'auth-token','bf346d0eca3a09362f60383dab28f92ed642833100f1d7df8f0c19c91e35c197','[\"*\"]','2026-01-22 01:14:12',NULL,'2026-01-22 01:08:23','2026-01-22 01:14:12'),(5,'App\\Models\\User',5,'auth-token','2620f6dfba4f71a8d26ee4052d2f4aba4f0450facc58ab939eefe0183334a72f','[\"*\"]','2026-01-22 07:54:16',NULL,'2026-01-22 07:51:49','2026-01-22 07:54:16'),(6,'App\\Models\\User',1,'auth-token','e02ef467e106da862c7b2908e44b9605cafd746eb8a9c9191da3c332fa7d71bb','[\"*\"]','2026-01-22 09:36:11',NULL,'2026-01-22 07:56:41','2026-01-22 09:36:11'),(9,'App\\Models\\User',1,'auth-token','49e63a797bc28ba1d243ec07f068907ea0c5e1929bef8a5098f5dfcee996fdff','[\"*\"]','2026-01-22 10:14:06',NULL,'2026-01-22 10:10:25','2026-01-22 10:14:06'),(12,'App\\Models\\User',1,'auth-token','1e2256107c79598acc0e3b13bb5565a89b0abef9364ed33cc0d17b437885a2ed','[\"*\"]','2026-01-23 05:06:49',NULL,'2026-01-23 04:45:58','2026-01-23 05:06:49'),(13,'App\\Models\\User',30,'auth-token','d192dd9056b34bddb38d14944f297f7eae197fe2772c2b056b76cb3618bfa413','[\"*\"]','2026-01-23 05:19:01',NULL,'2026-01-23 05:17:53','2026-01-23 05:19:01'),(27,'App\\Models\\User',1,'auth-token','915fad9f92be441db34ae70386e1c4006f26a3cbe427ee778cee351c4545346f','[\"*\"]','2026-01-23 09:40:19',NULL,'2026-01-23 09:27:29','2026-01-23 09:40:19'),(34,'App\\Models\\User',1,'auth-token','ca05dd5c46c9d01b69d7e12771dde996ddb58a31dff317c10d8a44bc62a55215','[\"*\"]','2026-01-23 11:52:17',NULL,'2026-01-23 11:45:50','2026-01-23 11:52:17'),(36,'App\\Models\\User',1,'auth-token','8a777741fc09ec4af914106712cd189a1a2dd1d948251d91889def588504ffdf','[\"*\"]','2026-01-24 06:46:44',NULL,'2026-01-23 20:15:36','2026-01-24 06:46:44'),(38,'App\\Models\\User',27,'auth-token','b95868b02e55afcd4e41318e9fb549889cd3e02a8a216491c797cd493cd1c976','[\"*\"]','2026-01-24 06:36:11',NULL,'2026-01-24 05:58:13','2026-01-24 06:36:11'),(39,'App\\Models\\User',1,'auth-token','87926da86cb74ce4710fdffd44587ab834fa90b4e438f8212d3148c52b05290c','[\"*\"]','2026-01-24 09:07:57',NULL,'2026-01-24 06:49:42','2026-01-24 09:07:57'),(44,'App\\Models\\User',1,'auth-token','ac433faaa0f0eebd653a088153b6818a58b32b25572a134475bd7e885fd9a679','[\"*\"]','2026-01-24 14:21:04',NULL,'2026-01-24 14:19:25','2026-01-24 14:21:04'),(49,'App\\Models\\User',2,'auth-token','f97c7155bb7c4a4d580398c6847bbb384ebc245e83d49b091bbcbe4d338c6ea2','[\"*\"]',NULL,NULL,'2026-01-24 17:41:53','2026-01-24 17:41:53');
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `siswa`
--

DROP TABLE IF EXISTS `siswa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `siswa` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `nis` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nisn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kelas_id` bigint unsigned DEFAULT NULL,
  `jenis_kelamin` enum('L','P') COLLATE utf8mb4_unicode_ci NOT NULL,
  `tempat_lahir` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tanggal_lahir` date DEFAULT NULL,
  `alamat` text COLLATE utf8mb4_unicode_ci,
  `telepon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nama_ayah` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pekerjaan_ayah` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nama_ibu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pekerjaan_ibu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nama_wali` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telepon_wali` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alamat_wali` text COLLATE utf8mb4_unicode_ci,
  `asal_sekolah` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tanggal_masuk` date DEFAULT NULL,
  `tahun_masuk` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_siswa` enum('aktif','mutasi_keluar','mutasi_masuk','lulus','keluar') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'aktif',
  `tanggal_mutasi` date DEFAULT NULL,
  `sekolah_tujuan` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sekolah_asal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alasan_mutasi` text COLLATE utf8mb4_unicode_ci,
  `tanggal_lulus` date DEFAULT NULL,
  `catatan` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `siswa_nis_unique` (`nis`),
  KEY `siswa_user_id_foreign` (`user_id`),
  KEY `siswa_kelas_id_foreign` (`kelas_id`),
  CONSTRAINT `siswa_kelas_id_foreign` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `siswa_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `siswa`
--

LOCK TABLES `siswa` WRITE;
/*!40000 ALTER TABLE `siswa` DISABLE KEYS */;
/*!40000 ALTER TABLE `siswa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` enum('admin','staff','kepala','bendahara','guru','siswa') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'siswa',
  `photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Abinyawafa','abinyawafa85@gmail.com','081138000859',NULL,'$2y$12$iKOwbG3DBcOPt.XpYw/GNOf8oETnEf8dCLR10mQd0SLHdYWjhTLFu','admin','uploads/profiles/1769188542_PYVoJbAsHD.jpg',1,NULL,'2026-01-21 22:53:05','2026-01-23 10:20:20'),(2,'Mukhlis Padilah, S.Pd.I','staff@simmada.com','081234567891',NULL,'$2y$12$uEbq83WwWn0OE7i1sfC6xurFgpk3DEfWxa.Z7CP74ZcwcSB9g/th2','staff',NULL,1,NULL,'2026-01-21 22:53:05','2026-01-23 08:07:54'),(3,'Kepala Madrasah','kepala@simmada.com','0811138000859',NULL,'$2y$12$HZfXTnlrYNg.77yItpcrA.9JGMdabZMTi.8sj.2j7/csCgmr01bT.','kepala',NULL,1,NULL,'2026-01-21 22:53:05','2026-01-23 08:07:57'),(4,'Bendahara','bendahara@simmada.com','081234567893',NULL,'$2y$12$FRCuELXmHCsp9.uL78KG9.ekXtmvZWKrljybjNJCSh5IZwtHyc/rS','bendahara',NULL,1,NULL,'2026-01-21 22:53:05','2026-01-23 08:08:00'),(5,'Guru Contoh','guru@simmada.com','081234567894',NULL,'$2y$12$93/Qj.UYTOeaxQGoBBX8S.PU78btev6/Fsv77.AtJ17PFmCIYvbe.','guru',NULL,1,NULL,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(6,'Siswa Contoh','siswa@simmada.com','081234567895',NULL,'$2y$12$8R8nP/VqbCwS3SBjhJRkMe2cf2CqXyCd7grua2.dwLlTKPsPcMGze','siswa',NULL,1,NULL,'2026-01-21 22:53:05','2026-01-21 22:53:05'),(7,'H. SAMSURI, S.Ag','guru1@mail.simmada.com',NULL,NULL,'$2y$12$DPTMiFgKDXMDju9DKDV2Wug2wFJQA3JxofodOSusIpTLtPT6cgU9G','guru',NULL,1,NULL,'2026-01-21 22:53:37','2026-01-21 22:53:37'),(8,'ALI SUBAKIR, S.Pd','guru2@mail.simmada.com',NULL,NULL,'$2y$12$d91Zn6duoJeIByH3tLNr1.BA9adrr4c4GcE.gkmqzXbbQJwFpl5/a','guru',NULL,1,NULL,'2026-01-21 22:53:37','2026-01-21 22:53:37'),(9,'NOR LATIFAH, S.Pd','guru3@mail.simmada.com',NULL,NULL,'$2y$12$AmG3hEKQTaH9zRFfd9oR6e30Joqn/45YIPEDcMGEWgPlVK0kFPp5C','guru',NULL,1,NULL,'2026-01-21 22:53:37','2026-01-21 22:53:37'),(10,'DEWI FITRIANI, S.Pd','guru4@mail.simmada.com',NULL,NULL,'$2y$12$zuHdfjdEc7D.YO0VYLqybOosbNIJoBzPMsCGfRGXwfX44u3AroJbm','guru',NULL,1,NULL,'2026-01-21 22:53:38','2026-01-21 22:53:38'),(11,'H. BAHAUDDIN','guru5@mail.simmada.com',NULL,NULL,'$2y$12$gJyjuJiSaff5r7w/wgBveu5nVCcYCBzS/50J6TvcP7e/CtxpmuSWa','guru',NULL,1,NULL,'2026-01-21 22:53:38','2026-01-21 22:53:38'),(12,'H. MUHAMMAD ARNI','guru6@mail.simmada.com',NULL,NULL,'$2y$12$wdpV.WRrgeqzvplBlTovPOjZ4HGXhtytRASePajpisf1gUzBDFR6a','guru',NULL,1,NULL,'2026-01-21 22:53:38','2026-01-21 22:53:38'),(13,'HERNITA, S.Pd','guru7@mail.simmada.com',NULL,NULL,'$2y$12$oPJNKG/C5/cRaFxf5v8uteyWYb3s.hGpB5DuvH2a5J4OjyGkaryFm','guru',NULL,1,NULL,'2026-01-21 22:53:39','2026-01-21 22:53:39'),(14,'HUMAINI','guru8@mail.simmada.com',NULL,NULL,'$2y$12$iMMLyfIF3rziA461zctF8eUahmCw9WKig9F64nGH4HhJ6skqibb8e','guru',NULL,1,NULL,'2026-01-21 22:53:39','2026-01-21 22:53:39'),(15,'JUMIATI, S.Pd','guru9@mail.simmada.com',NULL,NULL,'$2y$12$W9r2aF.c85DK3.LGh73rruAvQ759m.8wyT0b1WNkbfuDlq.WyPl5G','guru',NULL,1,NULL,'2026-01-21 22:53:40','2026-01-21 22:53:40'),(16,'MASKANARI, S.Pd','guru10@mail.simmada.com',NULL,NULL,'$2y$12$9wKa1OcqPXUCTCZcONBx8uoyLOoR0sRVr1yCNUQa2jInkzOatbMkW','guru',NULL,1,NULL,'2026-01-21 22:53:40','2026-01-21 22:53:40'),(17,'MUHAMMAD HOIRI ULFI','guru11@mail.simmada.com',NULL,NULL,'$2y$12$H6beGa2Ey8.0hcT5c.wRsuHOBSpEO7nW1PrBJlxHIjf1XgXvcrHS.','guru',NULL,1,NULL,'2026-01-21 22:53:40','2026-01-21 22:53:40'),(18,'MUKHLIS PADILAH, S.Pd.I','guru12@mail.simmada.com',NULL,NULL,'$2y$12$dzmC8qA6X.s/s1DtaExxkORFOExm6RBpOulkhu1DcEh9B.NLPXL6G','guru',NULL,1,NULL,'2026-01-21 22:53:41','2026-01-21 22:53:41'),(19,'NOOR KHAMSAH, S.Ag','guru13@mail.simmada.com',NULL,NULL,'$2y$12$RRp6yzuJArszf20953HXWe3AcUZfhp1GS.xYA1HBz3EiuVT2dclPe','guru',NULL,1,NULL,'2026-01-21 22:53:41','2026-01-21 22:53:41'),(20,'PUNIYANTI, S.Pd','guru14@mail.simmada.com',NULL,NULL,'$2y$12$tRhjGSHQ.rLeiqVL2wVh.OXRQn2yYUj9VK0H6vRqUT0NWqwpM5d1e','guru',NULL,1,NULL,'2026-01-21 22:53:41','2026-01-21 22:53:41'),(21,'RINA ARIF, S.Pd','guru15@mail.simmada.com',NULL,NULL,'$2y$12$b.j.zSnVaY0rm9hM0.dc4uwoQJ8M/IzUqR.1cFvuQn8.UwW7ZizVu','guru',NULL,1,NULL,'2026-01-21 22:53:42','2026-01-21 22:53:42'),(22,'RUDIAH, S.Pd','guru16@mail.simmada.com',NULL,NULL,'$2y$12$V4.lzR2nvGiJuUYICc4QBu7GndIPXaMxTPXp0BI18bXHINTwvzpbi','guru',NULL,1,NULL,'2026-01-21 22:53:42','2026-01-21 22:53:42'),(23,'SITI SARAH, S.Pd, M.Pd','guru17@mail.simmada.com',NULL,NULL,'$2y$12$0.ZlBID5TA.KzLdyEpU0zu.9xnvqhIrwuo5./OViM1lsxG9R9TLTy','guru',NULL,1,NULL,'2026-01-21 22:53:42','2026-01-21 22:53:42'),(24,'SRI FAUJI TEJAWATI, S.P','guru18@mail.simmada.com',NULL,NULL,'$2y$12$HJC/.9OwAmkvXdu5OTLPjOQQ8aYeXNpX1kkt1uYLJ8aEODg3ptKtm','guru',NULL,1,NULL,'2026-01-21 22:53:43','2026-01-21 22:53:43'),(25,'SRI WARTINI, S.Pd','guru19@mail.simmada.com',NULL,NULL,'$2y$12$F/FMnnPBkxCEO.6LM.0QIe7PSAA3FJyWZgWoogCOuaZxk/Tfw1WDC','guru',NULL,1,NULL,'2026-01-21 22:53:43','2026-01-21 22:53:43'),(26,'TIDI NURIATIN, S.Pd','guru20@mail.simmada.com',NULL,NULL,'$2y$12$2TjWv4THHgIulctKasPbeeu3mpOs0MRIcUO0nA31MHqmZ1jBvIo52','guru',NULL,1,NULL,'2026-01-21 22:53:43','2026-01-21 22:53:43'),(27,'WELLDA PUSPITA SARI, S.Pd.I','guru21@mail.simmada.com',NULL,NULL,'$2y$12$NjafcQcTatnkoJTHZ49zBeU.XenE5IYAnGPvNKG7F1ArB9uzMUDIW','guru',NULL,1,NULL,'2026-01-21 22:53:44','2026-01-21 22:53:44'),(28,'AHYATUDDIN','guru22@mail.simmada.com',NULL,NULL,'$2y$12$NjkglmsGHxyQHw2jxTZsruyM4U.hr0.9Oj5b/sHCjsR/rnyM5f9Z2','guru',NULL,1,NULL,'2026-01-21 22:53:44','2026-01-21 22:53:44'),(29,'RAHMADI','guru23@mail.simmada.com',NULL,NULL,'$2y$12$9RpfGbL2qo6wSY/RBUzNX.OnDDReMuBzC50adY8t5r/4nkzg1HkiO','guru',NULL,1,NULL,'2026-01-21 22:53:44','2026-01-21 22:53:44'),(30,'ABDURRAHMAN','guru24@mail.simmada.com',NULL,NULL,'$2y$12$rumUoJ7nxmtxpWIOSWQj1uIuoPY1u1vSQJYuc650taW0baPs4Tm/O','guru',NULL,1,NULL,'2026-01-21 22:53:45','2026-01-21 22:53:45');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-01-25  0:46:23
